/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.SQLUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql.PostgresJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql.PostgresTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresDialect
implements JdbcDialect {
    private static final Logger log = LoggerFactory.getLogger(PostgresDialect.class);
    private static final long serialVersionUID = -5834746193472465218L;
    public static final int DEFAULT_POSTGRES_FETCH_SIZE = 128;
    public String fieldIde = FieldIdeEnum.ORIGINAL.getValue();

    public PostgresDialect() {
    }

    public PostgresDialect(String fieldIde) {
        this.fieldIde = fieldIde;
    }

    @Override
    public String dialectName() {
        return "Postgres";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new PostgresJdbcRowConverter();
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new PostgresTypeMapper();
    }

    @Override
    public String hashModForField(String nativeType, String fieldName, int mod) {
        String quoteFieldName = this.quoteIdentifier(fieldName);
        if (StringUtils.isNotBlank((CharSequence)nativeType)) {
            quoteFieldName = this.convertType(quoteFieldName, nativeType);
        }
        return "(ABS(HASHTEXT(" + quoteFieldName + ")) % " + mod + ")";
    }

    @Override
    public String hashModForField(String fieldName, int mod) {
        return this.hashModForField(null, fieldName, mod);
    }

    @Override
    public Object queryNextChunkMax(Connection connection, JdbcSourceTable table, String columnName, int chunkSize, Object includedLowerBound) throws SQLException {
        Map<String, Column> columns = table.getCatalogTable().getTableSchema().getColumns().stream().collect(Collectors.toMap(c -> c.getName(), c -> c));
        Column column = columns.get(columnName);
        String quotedColumn = this.quoteIdentifier(columnName);
        quotedColumn = this.convertType(quotedColumn, column.getSourceType());
        String sqlQuery = StringUtils.isNotBlank((CharSequence)table.getQuery()) ? String.format("SELECT MAX(%s) FROM (SELECT %s FROM (%s) AS T1 WHERE %s >= ? ORDER BY %s ASC LIMIT %s) AS T2", quotedColumn, quotedColumn, table.getQuery(), quotedColumn, quotedColumn, chunkSize) : String.format("SELECT MAX(%s) FROM (SELECT %s FROM %s WHERE %s >= ? ORDER BY %s ASC LIMIT %s) AS T", quotedColumn, quotedColumn, this.tableIdentifier(table.getTablePath()), quotedColumn, quotedColumn, chunkSize);
        try (PreparedStatement ps = connection.prepareStatement(sqlQuery);){
            ps.setObject(1, includedLowerBound);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    Object object = rs.getObject(1);
                    return object;
                }
                throw new SQLException(String.format("No result returned after running query [%s]", sqlQuery));
            }
        }
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String uniqueColumns = Arrays.stream(uniqueKeyFields).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String updateClause = Arrays.stream(fieldNames).map(fieldName -> this.quoteIdentifier((String)fieldName) + "=EXCLUDED." + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String upsertSQL = String.format("%s ON CONFLICT (%s) DO UPDATE SET %s", this.getInsertIntoStatement(database, tableName, fieldNames), uniqueColumns, updateClause);
        return Optional.of(upsertSQL);
    }

    @Override
    public PreparedStatement creatPreparedStatement(Connection connection, String queryTemplate, int fetchSize) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(queryTemplate, 1003, 1007);
        if (fetchSize > 0) {
            statement.setFetchSize(fetchSize);
        } else {
            statement.setFetchSize(128);
        }
        return statement;
    }

    @Override
    public String tableIdentifier(String database, String tableName) {
        return this.quoteDatabaseIdentifier(database) + "." + this.quoteIdentifier(tableName);
    }

    @Override
    public String quoteIdentifier(String identifier) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append("\"").append(parts[i]).append("\"").append(".");
            }
            return sb.append("\"").append(this.getFieldIde(parts[parts.length - 1], this.fieldIde)).append("\"").toString();
        }
        return "\"" + this.getFieldIde(identifier, this.fieldIde) + "\"";
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return tablePath.getFullNameWithQuoted("\"");
    }

    @Override
    public String quoteDatabaseIdentifier(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)true);
    }

    @Override
    public Long approximateRowCntStatement(Connection connection, JdbcSourceTable table) throws SQLException {
        boolean useTableStats;
        boolean bl = useTableStats = StringUtils.isBlank((CharSequence)table.getQuery()) || !table.getQuery().toLowerCase().contains("where") && table.getTablePath() != null && !TablePath.DEFAULT.getFullName().equals(table.getTablePath().getFullName());
        if (useTableStats) {
            String rowCountQuery = String.format("SELECT reltuples FROM pg_class r WHERE relkind = 'r' AND relname = '%s';", table.getTablePath().getTableName());
            try (Statement stmt = connection.createStatement();){
                Long l;
                block14: {
                    log.info("Split Chunk, approximateRowCntStatement: {}", (Object)rowCountQuery);
                    ResultSet rs = stmt.executeQuery(rowCountQuery);
                    try {
                        if (!rs.next()) {
                            throw new SQLException(String.format("No result returned after running query [%s]", rowCountQuery));
                        }
                        l = rs.getLong(1);
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return l;
            }
        }
        return SQLUtils.countForSubquery(connection, table.getQuery());
    }

    @Override
    public String convertType(String columnName, String columnType) {
        if ("uuid".equals(columnType)) {
            return columnName + "::text";
        }
        return columnName;
    }
}

