/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver.SqlServerCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver.SqlServerTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver.SqlserverTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerCatalog
extends AbstractJdbcCatalog {
    private static final Logger log = LoggerFactory.getLogger(SqlServerCatalog.class);
    public static final String SELECT_COLUMNS_SQL_TEMPLATE = "SELECT tbl.name AS table_name,\n       col.name AS column_name,\n       ext.value AS comment,\n       col.column_id AS column_id,\n       types.name AS type,\n       col.max_length AS max_length,\n       col.precision AS precision,\n       col.scale AS scale,\n       col.is_nullable AS is_nullable,\n       def.definition AS default_value\nFROM sys.tables tbl\n    INNER JOIN sys.columns col ON tbl.object_id = col.object_id\n    LEFT JOIN sys.types types ON col.system_type_id = types.user_type_id\n    LEFT JOIN sys.extended_properties ext ON ext.major_id = col.object_id AND ext.minor_id = col.column_id\n    LEFT JOIN sys.default_constraints def ON col.default_object_id = def.object_id AND ext.minor_id = col.column_id AND ext.name = 'MS_Description'\nWHERE schema_name(tbl.schema_id) = '%s' %s\nORDER BY tbl.name, col.column_id";

    public SqlServerCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo, String defaultSchema) {
        super(catalogName, username, pwd, urlInfo, defaultSchema);
    }

    @Override
    protected String getDatabaseWithConditionSql(String databaseName) {
        return String.format(this.getListDatabaseSql() + "  where name = '%s'", databaseName);
    }

    @Override
    protected String getTableWithConditionSql(TablePath tablePath) {
        return String.format(this.getListTableSql(tablePath.getDatabaseName()) + "  and  TABLE_SCHEMA = '%s' and TABLE_NAME = '%s'", tablePath.getSchemaName(), tablePath.getTableName());
    }

    @Override
    protected String getListDatabaseSql() {
        return "SELECT NAME FROM sys.databases";
    }

    @Override
    protected String getListTableSql(String databaseName) {
        return "SELECT TABLE_SCHEMA, TABLE_NAME FROM " + databaseName + ".INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE = 'BASE TABLE'";
    }

    @Override
    protected String getSelectColumnsSql(TablePath tablePath) {
        String tableSql = StringUtils.isNotEmpty((CharSequence)tablePath.getTableName()) ? "AND tbl.name = '" + tablePath.getTableName() + "'" : "";
        return String.format(SELECT_COLUMNS_SQL_TEMPLATE, tablePath.getSchemaName(), tableSql);
    }

    @Override
    protected Column buildColumn(ResultSet resultSet) throws SQLException {
        String columnName = resultSet.getString("column_name");
        String dataType = resultSet.getString("type");
        int precision = resultSet.getInt("precision");
        int scale = resultSet.getInt("scale");
        long columnLength = resultSet.getLong("max_length");
        String comment = resultSet.getString("comment");
        Object defaultValue = resultSet.getObject("default_value");
        boolean isNullable = resultSet.getBoolean("is_nullable");
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(columnName).dataType(dataType).length(Long.valueOf(columnLength)).precision(Long.valueOf(precision)).scale(Integer.valueOf(scale)).nullable(isNullable).defaultValue(defaultValue).comment(comment).build();
        return SqlServerTypeConverter.INSTANCE.convert(typeDefine);
    }

    @Override
    protected String getCreateTableSql(TablePath tablePath, CatalogTable table, boolean createIndex) {
        return SqlServerCreateTableSqlBuilder.builder(tablePath, table, createIndex).build(tablePath, table);
    }

    @Override
    protected String getDropTableSql(TablePath tablePath) {
        return String.format("DROP TABLE %s", tablePath.getFullName());
    }

    @Override
    protected String getCreateDatabaseSql(String databaseName) {
        return String.format("CREATE DATABASE %s", databaseName);
    }

    @Override
    protected String getDropDatabaseSql(String databaseName) {
        return String.format("DROP DATABASE %s;", databaseName);
    }

    @Override
    protected void dropDatabaseInternal(String databaseName) throws CatalogException {
        this.closeDatabaseConnection(databaseName);
        super.dropDatabaseInternal(databaseName);
    }

    @Override
    protected String getUrlFromDatabaseName(String databaseName) {
        return this.baseUrl + ";databaseName=" + databaseName + ";" + this.suffix;
    }

    @Override
    public CatalogTable getTable(String sqlQuery) throws SQLException {
        Connection defaultConnection = this.getConnection(this.defaultUrl);
        return CatalogUtils.getCatalogTable(defaultConnection, sqlQuery, (JdbcDialectTypeMapper)new SqlserverTypeMapper());
    }

    @Override
    public String getExistDataSql(TablePath tablePath) {
        return String.format("select TOP 1 * from %s ;", tablePath.getFullNameWithQuoted("[", "]"));
    }

    @Override
    protected String getTruncateTableSql(TablePath tablePath) throws CatalogException {
        return String.format("TRUNCATE TABLE  %s", tablePath.getFullNameWithQuoted("[", "]"));
    }
}

