/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.saphana;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.saphana.SapHanaCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.saphana.SapHanaTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.saphana.SapHanaTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapHanaCatalog
extends AbstractJdbcCatalog {
    private static final Logger log = LoggerFactory.getLogger(SapHanaCatalog.class);
    private static final String SELECT_COLUMNS_SQL_TEMPLATE = "SELECT\n    C.COLUMN_NAME,\n    C.DATA_TYPE_NAME,\n    C.LENGTH,\n    C.SCALE,\n    C.IS_NULLABLE,\n    C.DEFAULT_VALUE,\n    C.COMMENTS,\n    E.DATA_TYPE_NAME AS ELEMENT_TYPE_NAME\nFROM\n    (SELECT * FROM SYS.TABLE_COLUMNS  UNION ALL SELECT * FROM SYS.VIEW_COLUMNS) C\n        LEFT JOIN\n    SYS.ELEMENT_TYPES E\n    ON\n        C.SCHEMA_NAME = E.SCHEMA_NAME\n            AND C.TABLE_NAME = E.OBJECT_NAME\n            AND C.COLUMN_NAME = E.ELEMENT_NAME\nWHERE\n    C.SCHEMA_NAME = '%s'\n  AND C.TABLE_NAME = '%s'\nORDER BY\n    C.POSITION ASC;";

    public SapHanaCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo, String defaultSchema) {
        super(catalogName, username, pwd, urlInfo, defaultSchema);
    }

    @Override
    protected String getDatabaseWithConditionSql(String databaseName) {
        return String.format(this.getListDatabaseSql() + " where SCHEMA_NAME = '%s'", databaseName);
    }

    @Override
    protected String getTableWithConditionSql(TablePath tablePath) {
        return String.format(this.getListTableSql(tablePath.getDatabaseName()) + " and TABLE_NAME = '%s'", tablePath.getTableName());
    }

    @Override
    protected String getListDatabaseSql() {
        return "SELECT SCHEMA_NAME FROM SCHEMAS";
    }

    @Override
    protected String getCreateDatabaseSql(String databaseName) {
        return String.format("CREATE SCHEMA \"%s\"", databaseName);
    }

    @Override
    protected String getDropDatabaseSql(String databaseName) {
        return String.format("DROP SCHEMA \"%s\"", databaseName);
    }

    @Override
    protected String getCreateTableSql(TablePath tablePath, CatalogTable table, boolean createIndex) {
        return new SapHanaCreateTableSqlBuilder(table, createIndex).build(tablePath);
    }

    @Override
    protected String getDropTableSql(TablePath tablePath) {
        return String.format("DROP TABLE %s.%s", CatalogUtils.quoteIdentifier(tablePath.getDatabaseName(), "", "\""), CatalogUtils.quoteIdentifier(tablePath.getTableName(), "", "\""));
    }

    @Override
    protected String getListTableSql(String databaseName) {
        return String.format("SELECT TABLE_NAME FROM TABLES WHERE SCHEMA_NAME = '%s'", databaseName);
    }

    @Override
    public String getListViewSql(String databaseName) {
        return String.format("SELECT VIEW_NAME FROM SYS.VIEWS WHERE SCHEMA_NAME = '%s'", databaseName);
    }

    @Override
    public String getListSynonymSql(String databaseName) {
        return String.format("SELECT SYNONYM_NAME FROM SYNONYMS WHERE SCHEMA_NAME = '%s'", databaseName);
    }

    @Override
    protected String getTableName(ResultSet rs) throws SQLException {
        return rs.getString(1);
    }

    @Override
    protected String getSelectColumnsSql(TablePath tablePath) {
        return String.format(SELECT_COLUMNS_SQL_TEMPLATE, tablePath.getDatabaseName(), tablePath.getTableName());
    }

    @Override
    public boolean tableExists(TablePath tablePath) throws CatalogException {
        try {
            if (StringUtils.isNotBlank((CharSequence)tablePath.getDatabaseName())) {
                return this.querySQLResultExists(this.getUrlFromDatabaseName(tablePath.getDatabaseName()), this.getTableWithConditionSql(tablePath)) || this.querySQLResultExists(this.getUrlFromDatabaseName(tablePath.getDatabaseName()), String.format(this.getListViewSql(tablePath.getDatabaseName()) + " AND VIEW_NAME = '%s'", tablePath.getTableName())) || this.querySQLResultExists(this.getUrlFromDatabaseName(tablePath.getDatabaseName()), String.format(this.getListSynonymSql(tablePath.getDatabaseName()) + " AND SYNONYM_NAME = '%s'", tablePath.getSchemaAndTableName()));
            }
            return this.querySQLResultExists(this.getUrlFromDatabaseName(tablePath.getDatabaseName()), this.getTableWithConditionSql(tablePath));
        }
        catch (DatabaseNotExistException e) {
            return false;
        }
        catch (SQLException e) {
            throw new SeaTunnelException("Failed to querySQLResult", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        String dbUrl = StringUtils.isNotBlank((CharSequence)tablePath.getDatabaseName()) ? this.getUrlFromDatabaseName(tablePath.getDatabaseName()) : this.getUrlFromDatabaseName(this.defaultDatabase);
        Connection conn = this.getConnection(dbUrl);
        TablePath originalTablePath = tablePath;
        if (this.listSynonym(tablePath.getDatabaseName()).contains(tablePath.getTableName())) {
            String sql = String.format("SELECT SYNONYM_NAME, SCHEMA_NAME, OBJECT_NAME, OBJECT_SCHEMA  FROM SYNONYMS  WHERE SCHEMA_NAME = '%s' AND SYNONYM_NAME = '%s' ", tablePath.getDatabaseName(), tablePath.getTableName());
            try (PreparedStatement statement = conn.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String refDatabaseName = resultSet.getString("OBJECT_SCHEMA");
                    String refTableName = resultSet.getString("OBJECT_NAME");
                    tablePath = TablePath.of((String)refDatabaseName, (String)refTableName);
                }
            }
            catch (Exception e) {
                throw new CatalogException(String.format("Failed getting SYNONYM %s", tablePath.getFullName()), (Throwable)e);
            }
        }
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            Optional<PrimaryKey> primaryKey = this.getPrimaryKey(metaData, tablePath);
            List<ConstraintKey> constraintKeys = this.getConstraintKeys(metaData, tablePath);
            try (PreparedStatement ps = conn.prepareStatement(this.getSelectColumnsSql(tablePath));){
                CatalogTable catalogTable;
                block33: {
                    ResultSet resultSet = ps.executeQuery();
                    try {
                        TableSchema.Builder builder = TableSchema.builder();
                        this.buildColumnsWithErrorCheck(tablePath, resultSet, builder);
                        primaryKey.ifPresent(arg_0 -> ((TableSchema.Builder)builder).primaryKey(arg_0));
                        constraintKeys.forEach(arg_0 -> ((TableSchema.Builder)builder).constraintKey(arg_0));
                        TableIdentifier tableIdentifier = this.getTableIdentifier(originalTablePath);
                        catalogTable = CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)builder.build(), this.buildConnectorOptions(tablePath), Collections.emptyList(), (String)"", (String)this.catalogName);
                        if (resultSet == null) break block33;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                return catalogTable;
            }
        }
        catch (SeaTunnelRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed getting table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    @Override
    protected Column buildColumn(ResultSet resultSet) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String typeName = resultSet.getString("DATA_TYPE_NAME");
        Long columnLength = resultSet.getLong("LENGTH");
        Integer columnScale = resultSet.getObject("SCALE", Integer.class);
        String fullTypeName = SapHanaTypeConverter.appendColumnSizeIfNeed(typeName, columnLength, columnScale);
        String columnComment = resultSet.getString("COMMENTS");
        Object defaultValue = resultSet.getObject("DEFAULT_VALUE");
        boolean isNullable = resultSet.getString("IS_NULLABLE").equals("TRUE");
        if (typeName.equalsIgnoreCase("ARRAY")) {
            fullTypeName = SapHanaTypeConverter.appendColumnSizeIfNeed(resultSet.getString("ELEMENT_TYPE_NAME"), columnLength, columnScale) + " ARRAY";
        }
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(columnName).columnType(fullTypeName).dataType(typeName).length(columnLength).precision(columnLength).scale(columnScale).nullable(isNullable).defaultValue(defaultValue).comment(columnComment).build();
        return SapHanaTypeConverter.INSTANCE.convert(typeDefine);
    }

    @Override
    protected String getUrlFromDatabaseName(String databaseName) {
        return this.defaultUrl;
    }

    @Override
    protected String getOptionTableName(TablePath tablePath) {
        return tablePath.getTableName();
    }

    private List<String> listTables() {
        List<String> databases = this.listDatabases();
        return this.listTables(databases.get(0));
    }

    @Override
    public CatalogTable getTable(String sqlQuery) throws SQLException {
        Connection defaultConnection = this.getConnection(this.defaultUrl);
        return CatalogUtils.getCatalogTable(defaultConnection, sqlQuery, (JdbcDialectTypeMapper)new SapHanaTypeMapper());
    }

    @Override
    protected String getTruncateTableSql(TablePath tablePath) {
        return String.format("TRUNCATE TABLE \"%s\".\"%s\"", tablePath.getDatabaseName(), tablePath.getTableName());
    }

    @Override
    protected String getExistDataSql(TablePath tablePath) {
        return String.format("SELECT 1 FROM \"%s\".\"%s\"", tablePath.getDatabaseName(), tablePath.getTableName());
    }

    @Override
    protected List<ConstraintKey> getConstraintKeys(DatabaseMetaData metaData, TablePath tablePath) throws SQLException {
        try {
            return this.getConstraintKeys(metaData, tablePath.getDatabaseName(), tablePath.getSchemaName(), tablePath.getTableName());
        }
        catch (SQLException e) {
            log.info("Obtain constraint failure", (Throwable)e);
            return new ArrayList<ConstraintKey>();
        }
    }
}

