/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.source;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.ConfigValidator;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.JdbcInputFormat;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceFactory;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceReader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.PartitionParameter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.JdbcSourceState;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SeaTunnelSource.class})
public class JdbcSource
implements SeaTunnelSource<SeaTunnelRow, JdbcSourceSplit, JdbcSourceState>,
SupportParallelism,
SupportColumnProjection {
    protected static final Logger LOG = LoggerFactory.getLogger(JdbcSource.class);
    private JdbcSourceConfig jdbcSourceConfig;
    private SeaTunnelRowType typeInfo;
    private JdbcDialect jdbcDialect;
    private JdbcInputFormat inputFormat;
    private PartitionParameter partitionParameter;
    private JdbcConnectionProvider jdbcConnectionProvider;
    private String query;

    public JdbcSource(JdbcSourceConfig jdbcSourceConfig, SeaTunnelRowType typeInfo, JdbcDialect jdbcDialect, JdbcInputFormat inputFormat, PartitionParameter partitionParameter, JdbcConnectionProvider jdbcConnectionProvider, String query) {
        this.jdbcSourceConfig = jdbcSourceConfig;
        this.typeInfo = typeInfo;
        this.jdbcDialect = jdbcDialect;
        this.inputFormat = inputFormat;
        this.partitionParameter = partitionParameter;
        this.jdbcConnectionProvider = jdbcConnectionProvider;
        this.query = query;
    }

    public String getPluginName() {
        return "Jdbc";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        ReadonlyConfig config = ReadonlyConfig.fromConfig((Config)pluginConfig);
        ConfigValidator.of((ReadonlyConfig)config).validate(new JdbcSourceFactory().optionRule());
        this.jdbcSourceConfig = JdbcSourceConfig.of(config);
        this.jdbcConnectionProvider = new SimpleJdbcConnectionProvider(this.jdbcSourceConfig.getJdbcConnectionConfig());
        this.query = this.jdbcSourceConfig.getQuery();
        this.jdbcDialect = JdbcDialectLoader.load(this.jdbcSourceConfig.getJdbcConnectionConfig().getUrl(), this.jdbcSourceConfig.getJdbcConnectionConfig().getCompatibleMode());
        try (Connection connection = this.jdbcConnectionProvider.getOrEstablishConnection();){
            this.typeInfo = this.initTableField(connection);
            this.partitionParameter = this.createPartitionParameter(this.jdbcConnectionProvider.getOrEstablishConnection());
        }
        catch (Exception e) {
            throw new PrepareFailException("jdbc", PluginType.SOURCE, e.toString());
        }
        if (this.partitionParameter != null) {
            this.query = JdbcSourceFactory.obtainPartitionSql(this.jdbcDialect, this.partitionParameter, this.jdbcSourceConfig.getQuery());
        }
        this.inputFormat = new JdbcInputFormat(this.jdbcConnectionProvider, this.jdbcDialect, this.typeInfo, this.query, this.jdbcSourceConfig.getFetchSize(), this.jdbcSourceConfig.getJdbcConnectionConfig().isAutoCommit());
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.typeInfo;
    }

    public SourceReader<SeaTunnelRow, JdbcSourceSplit> createReader(SourceReader.Context readerContext) throws Exception {
        return new JdbcSourceReader(this.inputFormat, readerContext);
    }

    public Serializer<JdbcSourceSplit> getSplitSerializer() {
        return super.getSplitSerializer();
    }

    public SourceSplitEnumerator<JdbcSourceSplit, JdbcSourceState> createEnumerator(SourceSplitEnumerator.Context<JdbcSourceSplit> enumeratorContext) throws Exception {
        return new JdbcSourceSplitEnumerator(enumeratorContext, this.jdbcSourceConfig, this.partitionParameter);
    }

    public SourceSplitEnumerator<JdbcSourceSplit, JdbcSourceState> restoreEnumerator(SourceSplitEnumerator.Context<JdbcSourceSplit> enumeratorContext, JdbcSourceState checkpointState) throws Exception {
        return new JdbcSourceSplitEnumerator(enumeratorContext, this.jdbcSourceConfig, this.partitionParameter, checkpointState);
    }

    private SeaTunnelRowType initTableField(Connection conn) {
        JdbcDialectTypeMapper jdbcDialectTypeMapper = this.jdbcDialect.getJdbcDialectTypeMapper();
        ArrayList seaTunnelDataTypes = new ArrayList();
        ArrayList<String> fieldNames = new ArrayList<String>();
        try {
            ResultSetMetaData resultSetMetaData = this.jdbcDialect.getResultSetMetaData(conn, this.jdbcSourceConfig);
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                fieldNames.add(resultSetMetaData.getColumnLabel(i));
                seaTunnelDataTypes.add(jdbcDialectTypeMapper.mapping(resultSetMetaData, i));
            }
        }
        catch (Exception e) {
            LOG.warn("get row type info exception", (Throwable)e);
        }
        return new SeaTunnelRowType(fieldNames.toArray(new String[0]), seaTunnelDataTypes.toArray(new SeaTunnelDataType[0]));
    }

    private PartitionParameter createPartitionParameter(Connection connection) {
        if (this.jdbcSourceConfig.getPartitionColumn().isPresent()) {
            String partitionColumn = this.jdbcSourceConfig.getPartitionColumn().get();
            SeaTunnelDataType<?> dataType = JdbcSourceFactory.validationPartitionColumn(partitionColumn, this.typeInfo);
            return JdbcSourceFactory.createPartitionParameter(this.jdbcSourceConfig, partitionColumn, dataType, connection);
        }
        LOG.info("The partition_column parameter is not configured, and the source parallelism is set to 1");
        return null;
    }

    public JdbcSource() {
    }
}

