/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.sink;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportDataSaveMode;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcExactlyOnceSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcSinkAggregatedCommitter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.JdbcAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.JdbcSinkState;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.XidInfo;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSink.class})
public class JdbcSink
implements SeaTunnelSink<SeaTunnelRow, JdbcSinkState, XidInfo, JdbcAggregatedCommitInfo>,
SupportDataSaveMode {
    private SeaTunnelRowType seaTunnelRowType;
    private JobContext jobContext;
    private JdbcSinkConfig jdbcSinkConfig;
    private JdbcDialect dialect;
    private ReadonlyConfig config;
    private DataSaveMode dataSaveMode;
    private CatalogTable catalogTable;

    public JdbcSink(ReadonlyConfig config, JdbcSinkConfig jdbcSinkConfig, JdbcDialect dialect, DataSaveMode dataSaveMode, CatalogTable catalogTable) {
        this.config = config;
        this.jdbcSinkConfig = jdbcSinkConfig;
        this.dialect = dialect;
        this.dataSaveMode = dataSaveMode;
        this.catalogTable = catalogTable;
        this.seaTunnelRowType = catalogTable.getTableSchema().toPhysicalRowDataType();
    }

    public JdbcSink() {
    }

    public String getPluginName() {
        return "Jdbc";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        this.config = ReadonlyConfig.fromConfig((Config)pluginConfig);
        this.jdbcSinkConfig = JdbcSinkConfig.of(this.config);
        this.dialect = JdbcDialectLoader.load(this.jdbcSinkConfig.getJdbcConnectionConfig().getUrl(), this.jdbcSinkConfig.getJdbcConnectionConfig().getCompatibleMode());
        this.dataSaveMode = DataSaveMode.KEEP_SCHEMA_AND_DATA;
    }

    public SinkWriter<SeaTunnelRow, XidInfo, JdbcSinkState> createWriter(SinkWriter.Context context) throws IOException {
        Object sinkWriter = this.jdbcSinkConfig.isExactlyOnce() ? new JdbcExactlyOnceSinkWriter(context, this.jobContext, this.dialect, this.jdbcSinkConfig, this.seaTunnelRowType, new ArrayList<JdbcSinkState>()) : new JdbcSinkWriter(context, this.dialect, this.jdbcSinkConfig, this.seaTunnelRowType);
        return sinkWriter;
    }

    public SinkWriter<SeaTunnelRow, XidInfo, JdbcSinkState> restoreWriter(SinkWriter.Context context, List<JdbcSinkState> states) throws IOException {
        if (this.jdbcSinkConfig.isExactlyOnce()) {
            return new JdbcExactlyOnceSinkWriter(context, this.jobContext, this.dialect, this.jdbcSinkConfig, this.seaTunnelRowType, states);
        }
        return super.restoreWriter(context, states);
    }

    public Optional<SinkAggregatedCommitter<XidInfo, JdbcAggregatedCommitInfo>> createAggregatedCommitter() {
        if (this.jdbcSinkConfig.isExactlyOnce()) {
            return Optional.of(new JdbcSinkAggregatedCommitter(this.jdbcSinkConfig));
        }
        return Optional.empty();
    }

    public void setTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    public SeaTunnelDataType<SeaTunnelRow> getConsumedType() {
        return this.seaTunnelRowType;
    }

    public Optional<Serializer<JdbcAggregatedCommitInfo>> getAggregatedCommitInfoSerializer() {
        if (this.jdbcSinkConfig.isExactlyOnce()) {
            return Optional.of(new DefaultSerializer());
        }
        return Optional.empty();
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public Optional<Serializer<XidInfo>> getCommitInfoSerializer() {
        if (this.jdbcSinkConfig.isExactlyOnce()) {
            return Optional.of(new DefaultSerializer());
        }
        return Optional.empty();
    }

    public DataSaveMode getUserConfigSaveMode() {
        return this.dataSaveMode;
    }

    public void handleSaveMode(DataSaveMode saveMode) {
        Map catalogOptions;
        if (this.catalogTable != null && (catalogOptions = (Map)this.config.get(CatalogOptions.CATALOG_OPTIONS)) != null) {
            String factoryId = (String)catalogOptions.get(CommonOptions.FACTORY_ID.key());
            if (StringUtils.isBlank((CharSequence)this.jdbcSinkConfig.getDatabase())) {
                return;
            }
            CatalogFactory catalogFactory = (CatalogFactory)FactoryUtil.discoverFactory((ClassLoader)Thread.currentThread().getContextClassLoader(), CatalogFactory.class, (String)factoryId);
            if (catalogFactory != null) {
                try (Catalog catalog = catalogFactory.createCatalog(catalogFactory.factoryIdentifier(), ReadonlyConfig.fromMap(new HashMap(catalogOptions)));){
                    catalog.open();
                    TablePath tablePath = TablePath.of((String)(this.jdbcSinkConfig.getDatabase() + "." + this.jdbcSinkConfig.getTable()));
                    if (!catalog.databaseExists(this.jdbcSinkConfig.getDatabase())) {
                        catalog.createDatabase(tablePath, true);
                    }
                    if (!catalog.tableExists(tablePath)) {
                        catalog.createTable(tablePath, this.catalogTable, true);
                    }
                }
                catch (Exception e) {
                    throw new JdbcConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.HANDLE_SAVE_MODE_FAILED, e);
                }
            }
        }
    }
}

