/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.OptionValidationException;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver.SqlServerCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver.SqlServerURLParser;

@AutoService(value={Factory.class})
public class SqlServerCatalogFactory
implements CatalogFactory {
    public static final String IDENTIFIER = "SqlServer";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        String url = (String)options.get(JdbcCatalogOptions.BASE_URL);
        JdbcUrlUtil.UrlInfo urlInfo = SqlServerURLParser.parse(url);
        Optional defaultDatabase = urlInfo.getDefaultDatabase();
        if (!defaultDatabase.isPresent()) {
            throw new OptionValidationException(JdbcCatalogOptions.BASE_URL);
        }
        return new SqlServerCatalog(catalogName, (String)options.get(JdbcCatalogOptions.USERNAME), (String)options.get(JdbcCatalogOptions.PASSWORD), urlInfo, (String)options.get(JdbcCatalogOptions.SCHEMA));
    }

    public OptionRule optionRule() {
        return JdbcCatalogOptions.BASE_RULE.build();
    }
}

