/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.psql;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.psql.PostgresDataTypeConvertor;

public class PostgresCreateTableSqlBuilder {
    private List<Column> columns;
    private PrimaryKey primaryKey;
    private PostgresDataTypeConvertor postgresDataTypeConvertor;
    private String sourceCatalogName;

    public PostgresCreateTableSqlBuilder(CatalogTable catalogTable) {
        this.columns = catalogTable.getTableSchema().getColumns();
        this.primaryKey = catalogTable.getTableSchema().getPrimaryKey();
        this.postgresDataTypeConvertor = new PostgresDataTypeConvertor();
        this.sourceCatalogName = catalogTable.getCatalogName();
    }

    public String build(TablePath tablePath) {
        StringBuilder createTableSql = new StringBuilder();
        createTableSql.append("CREATE TABLE IF NOT EXISTS ").append(tablePath.getSchemaAndTableName()).append(" (\n");
        List columnSqls = this.columns.stream().map(this::buildColumnSql).collect(Collectors.toList());
        createTableSql.append(String.join((CharSequence)",\n", columnSqls));
        createTableSql.append("\n);");
        List commentSqls = this.columns.stream().filter(column -> StringUtils.isNotBlank((CharSequence)column.getComment())).map(columns -> this.buildColumnCommentSql((Column)columns, tablePath.getSchemaAndTableName())).collect(Collectors.toList());
        if (!commentSqls.isEmpty()) {
            createTableSql.append("\n");
            createTableSql.append(String.join((CharSequence)";\n", commentSqls)).append(";");
        }
        return createTableSql.toString();
    }

    private String buildColumnSql(Column column) {
        StringBuilder columnSql = new StringBuilder();
        columnSql.append(column.getName()).append(" ");
        String columnType = this.sourceCatalogName.equals("postgres") ? column.getSourceType() : this.buildColumnType(column);
        columnSql.append(columnType);
        if (!column.isNullable()) {
            columnSql.append(" NOT NULL");
        }
        if (this.primaryKey != null && this.primaryKey.getColumnNames().contains(column.getName())) {
            columnSql.append(" PRIMARY KEY");
        }
        return columnSql.toString();
    }

    private String buildColumnType(Column column) {
        SqlType sqlType = column.getDataType().getSqlType();
        Long columnLength = column.getLongColumnLength();
        switch (sqlType) {
            case BYTES: {
                return "bytea";
            }
            case STRING: {
                if (columnLength > 0L && columnLength < 0xA00000L) {
                    return "varchar(" + columnLength + ")";
                }
                return "text";
            }
        }
        Object type = this.postgresDataTypeConvertor.toConnectorType(column.getDataType(), (Map)null);
        if (((String)type).equals("numeric")) {
            DecimalType decimalType = (DecimalType)column.getDataType();
            return "numeric(" + decimalType.getPrecision() + "," + decimalType.getScale() + ")";
        }
        return type;
    }

    private String buildColumnCommentSql(Column column, String tableName) {
        StringBuilder columnCommentSql = new StringBuilder();
        columnCommentSql.append("COMMENT ON COLUMN ").append(tableName).append(".");
        columnCommentSql.append(column.getName()).append(" IS '").append(column.getComment()).append("'");
        return columnCommentSql.toString();
    }
}

