/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle.OracleDataTypeConvertor;

public class OracleCreateTableSqlBuilder {
    private List<Column> columns;
    private PrimaryKey primaryKey;
    private OracleDataTypeConvertor oracleDataTypeConvertor;
    private String sourceCatalogName;

    public OracleCreateTableSqlBuilder(CatalogTable catalogTable) {
        this.columns = catalogTable.getTableSchema().getColumns();
        this.primaryKey = catalogTable.getTableSchema().getPrimaryKey();
        this.oracleDataTypeConvertor = new OracleDataTypeConvertor();
        this.sourceCatalogName = catalogTable.getCatalogName();
    }

    public String build(TablePath tablePath) {
        StringBuilder createTableSql = new StringBuilder();
        createTableSql.append("CREATE TABLE ").append(tablePath.getSchemaAndTableName()).append(" (\n");
        List columnSqls = this.columns.stream().map(this::buildColumnSql).collect(Collectors.toList());
        if (this.primaryKey != null && this.primaryKey.getColumnNames() != null && this.primaryKey.getColumnNames().size() > 0) {
            columnSqls.add(this.buildPrimaryKeySql(this.primaryKey));
        }
        createTableSql.append(String.join((CharSequence)",\n", columnSqls));
        createTableSql.append("\n)");
        List commentSqls = this.columns.stream().filter(column -> StringUtils.isNotBlank((CharSequence)column.getComment())).map(column -> this.buildColumnCommentSql((Column)column, tablePath.getSchemaAndTableName())).collect(Collectors.toList());
        if (!commentSqls.isEmpty()) {
            createTableSql.append(";\n");
            createTableSql.append(String.join((CharSequence)";\n", commentSqls));
        }
        return createTableSql.toString();
    }

    private String buildColumnSql(Column column) {
        StringBuilder columnSql = new StringBuilder();
        columnSql.append(column.getName()).append(" ");
        String columnType = this.sourceCatalogName.equals("oracle") ? column.getSourceType() : this.buildColumnType(column);
        columnSql.append(columnType);
        if (!column.isNullable()) {
            columnSql.append(" NOT NULL");
        }
        return columnSql.toString();
    }

    private String buildColumnType(Column column) {
        SqlType sqlType = column.getDataType().getSqlType();
        Long columnLength = column.getLongColumnLength();
        Long bitLen = column.getBitLen();
        switch (sqlType) {
            case BYTES: {
                if (bitLen < 0L || bitLen > 2000L) {
                    return "BLOB";
                }
                return "RAW(" + bitLen + ")";
            }
            case STRING: {
                if (columnLength > 0L && columnLength < 4000L) {
                    return "VARCHAR2(" + columnLength + " CHAR)";
                }
                return "CLOB";
            }
        }
        Object type = this.oracleDataTypeConvertor.toConnectorType(column.getDataType(), (Map)null);
        if (((String)type).equals("NUMBER")) {
            if (column.getDataType() instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)column.getDataType();
                return "NUMBER(" + decimalType.getPrecision() + "," + decimalType.getScale() + ")";
            }
            return "NUMBER";
        }
        return type;
    }

    private String buildPrimaryKeySql(PrimaryKey primaryKey) {
        String randomSuffix = UUID.randomUUID().toString().replace("-", "").substring(0, 4);
        String columnNamesString = String.join((CharSequence)", ", primaryKey.getColumnNames());
        String primaryKeyStr = primaryKey.getPrimaryKey();
        if (primaryKeyStr.length() > 25) {
            primaryKeyStr = primaryKeyStr.substring(0, 25);
        }
        return "CONSTRAINT " + primaryKeyStr + "_" + randomSuffix + " PRIMARY KEY (" + columnNamesString + ")";
    }

    private String buildColumnCommentSql(Column column, String tableName) {
        StringBuilder columnCommentSql = new StringBuilder();
        columnCommentSql.append("COMMENT ON COLUMN ").append(tableName).append(".");
        columnCommentSql.append(column.getName()).append(" IS '").append(column.getComment()).append("'");
        return columnCommentSql.toString();
    }
}

