/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql;

import com.mysql.cj.MysqlType;
import com.mysql.cj.util.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql.MysqlCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql.MysqlDataTypeConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlCatalog
extends AbstractJdbcCatalog {
    private static final Logger log = LoggerFactory.getLogger(MySqlCatalog.class);
    protected static final Set<String> SYS_DATABASES = new HashSet<String>(4);
    private final String SELECT_COLUMNS = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME ='%s'";
    protected final Map<String, Connection> connectionMap = new ConcurrentHashMap<String, Connection>();

    public MySqlCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo) {
        super(catalogName, username, pwd, urlInfo, null);
    }

    public Connection getConnection(String url) {
        if (this.connectionMap.containsKey(url)) {
            return this.connectionMap.get(url);
        }
        try {
            Connection connection = DriverManager.getConnection(url, this.username, this.pwd);
            this.connectionMap.put(url, connection);
            return connection;
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed connecting to %s via JDBC.", url), (Throwable)e);
        }
    }

    @Override
    public void close() throws CatalogException {
        for (Map.Entry<String, Connection> entry : this.connectionMap.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (SQLException e) {
                throw new CatalogException(String.format("Failed to close %s via JDBC.", entry.getKey()), (Throwable)e);
            }
        }
        super.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listDatabases() throws CatalogException {
        try (PreparedStatement ps = this.defaultConnection.prepareStatement("SHOW DATABASES;");){
            ArrayList<String> databases = new ArrayList<String>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String databaseName = rs.getString(1);
                if (SYS_DATABASES.contains(databaseName)) continue;
                databases.add(rs.getString(1));
            }
            ArrayList<String> arrayList = databases;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        String dbUrl = this.getUrlFromDatabaseName(databaseName);
        Connection connection = this.getConnection(dbUrl);
        try (PreparedStatement ps = connection.prepareStatement("SHOW TABLES;");){
            ResultSet rs = ps.executeQuery();
            ArrayList<String> tables = new ArrayList<String>();
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
            ArrayList<String> arrayList = tables;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void buildTable(ResultSet resultSet, TableSchema.Builder builder) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String sourceType = resultSet.getString("COLUMN_TYPE");
        String typeName = resultSet.getString("DATA_TYPE").toUpperCase();
        int precision = resultSet.getInt("NUMERIC_PRECISION");
        int scale = resultSet.getInt("NUMERIC_SCALE");
        long columnLength = resultSet.getLong("CHARACTER_MAXIMUM_LENGTH");
        long octetLength = resultSet.getLong("CHARACTER_OCTET_LENGTH");
        if (sourceType.toLowerCase(Locale.ROOT).contains("unsigned")) {
            typeName = typeName + "_UNSIGNED";
        }
        SeaTunnelDataType<?> type = this.fromJdbcType(typeName, precision, scale);
        String comment = resultSet.getString("COLUMN_COMMENT");
        Object defaultValue = resultSet.getObject("COLUMN_DEFAULT");
        String isNullableStr = resultSet.getString("IS_NULLABLE");
        boolean isNullable = isNullableStr.equals("YES");
        long bitLen = 0L;
        MysqlType mysqlType = MysqlType.valueOf((String)typeName);
        switch (mysqlType) {
            case BIT: {
                bitLen = precision;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                columnLength = octetLength;
                break;
            }
            case BINARY: 
            case VARBINARY: {
                bitLen = octetLength * 4L * 8L;
                break;
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                bitLen = columnLength << 3;
                break;
            }
            case JSON: {
                columnLength = 0x100000000L;
                break;
            }
        }
        PhysicalColumn physicalColumn = PhysicalColumn.of((String)columnName, type, (Integer)0, (boolean)isNullable, (Object)defaultValue, (String)comment, (String)sourceType, (boolean)sourceType.contains("unsigned"), (boolean)sourceType.contains("zerofill"), (Long)bitLen, null, (Long)columnLength);
        builder.column((Column)physicalColumn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> getColumnsDefaultValue(TablePath tablePath, Connection conn) {
        StringBuilder queryBuf = new StringBuilder("SHOW FULL COLUMNS FROM ");
        queryBuf.append(StringUtils.quoteIdentifier((String)tablePath.getTableName(), (String)"`", (boolean)false));
        queryBuf.append(" FROM ");
        queryBuf.append(StringUtils.quoteIdentifier((String)tablePath.getDatabaseName(), (String)"`", (boolean)false));
        try (PreparedStatement ps2 = conn.prepareStatement(queryBuf.toString());){
            ResultSet rs = ps2.executeQuery();
            HashMap<String, Object> result = new HashMap<String, Object>();
            while (rs.next()) {
                String field = rs.getString("Field");
                Object defaultValue = rs.getObject("Default");
                result.put(field, defaultValue);
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed getting table(%s) columns default value", tablePath.getFullName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean createTableInternal(TablePath tablePath, CatalogTable table) throws CatalogException {
        String dbUrl = this.getUrlFromDatabaseName(tablePath.getDatabaseName());
        String createTableSql = MysqlCreateTableSqlBuilder.builder(tablePath, table).build(table.getCatalogName());
        Connection connection = this.getConnection(dbUrl);
        log.info("create table sql: {}", (Object)createTableSql);
        try (PreparedStatement ps = connection.prepareStatement(createTableSql);){
            boolean bl = ps.execute();
            return bl;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed creating table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean dropTableInternal(TablePath tablePath) throws CatalogException {
        String dbUrl = this.getUrlFromDatabaseName(tablePath.getDatabaseName());
        Connection connection = this.getConnection(dbUrl);
        try (PreparedStatement ps = connection.prepareStatement(String.format("DROP TABLE IF EXISTS %s;", tablePath.getFullName()));){
            boolean bl = ps.execute();
            return bl;
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed dropping table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean createDatabaseInternal(String databaseName) throws CatalogException {
        try (PreparedStatement ps = this.defaultConnection.prepareStatement(String.format("CREATE DATABASE `%s`;", databaseName));){
            boolean bl = ps.execute();
            return bl;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed creating database %s in catalog %s", databaseName, this.catalogName), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean dropDatabaseInternal(String databaseName) throws CatalogException {
        try (PreparedStatement ps = this.defaultConnection.prepareStatement(String.format("DROP DATABASE `%s`;", databaseName));){
            boolean bl = ps.execute();
            return bl;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed dropping database %s in catalog %s", databaseName, this.catalogName), (Throwable)e);
        }
    }

    private SeaTunnelDataType<?> fromJdbcType(ResultSetMetaData metadata, int colIndex) throws SQLException {
        MysqlType mysqlType = MysqlType.getByName((String)metadata.getColumnTypeName(colIndex));
        HashMap<String, Object> dataTypeProperties = new HashMap<String, Object>();
        dataTypeProperties.put("precision", metadata.getPrecision(colIndex));
        dataTypeProperties.put("scale", metadata.getScale(colIndex));
        return new MysqlDataTypeConvertor().toSeaTunnelType(mysqlType, dataTypeProperties);
    }

    private SeaTunnelDataType<?> fromJdbcType(String typeName, int precision, int scale) {
        MysqlType mysqlType = MysqlType.getByName((String)typeName);
        HashMap<String, Object> dataTypeProperties = new HashMap<String, Object>();
        dataTypeProperties.put("precision", precision);
        dataTypeProperties.put("scale", scale);
        return new MysqlDataTypeConvertor().toSeaTunnelType(mysqlType, dataTypeProperties);
    }

    private Map<String, String> buildConnectorOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>(8);
        options.put("connector", "jdbc");
        options.put("url", this.baseUrl + tablePath.getDatabaseName());
        options.put("table-name", tablePath.getFullName());
        options.put("username", this.username);
        options.put("password", this.pwd);
        return options;
    }

    private String getUrlFromDatabaseName(String databaseName) {
        String url = this.baseUrl.endsWith("/") ? this.baseUrl : this.baseUrl + "/";
        return url + databaseName + this.suffix;
    }

    static {
        SYS_DATABASES.add("information_schema");
        SYS_DATABASES.add("mysql");
        SYS_DATABASES.add("performance_schema");
        SYS_DATABASES.add("sys");
    }
}

