/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.template;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.template.TemplateNode;

public class InternalNode
extends TemplateNode {
    private Map<String, TemplateNode> children = new HashMap<String, TemplateNode>();
    private boolean shareTime;

    public InternalNode(String name, boolean shareTime) {
        super(name);
        this.shareTime = shareTime;
    }

    @Override
    public void addChild(TemplateNode node) throws StatementExecutionException {
        if (this.children.containsKey(node.getName())) {
            throw new StatementExecutionException("Duplicated child of node in template.");
        }
        this.children.put(node.getName(), node);
    }

    @Override
    public void deleteChild(TemplateNode node) {
        if (this.children.containsKey(node.getName())) {
            this.children.remove(node.getName());
        }
    }

    @Override
    public Map<String, TemplateNode> getChildren() {
        return this.children;
    }

    @Override
    public boolean isShareTime() {
        return this.shareTime;
    }
}

