/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iotdb.source;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.iotdb.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.iotdb.exception.IotdbConnectorException;
import org.apache.seatunnel.connectors.seatunnel.iotdb.source.IoTDBSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.iotdb.state.IoTDBSourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBSourceSplitEnumerator
implements SourceSplitEnumerator<IoTDBSourceSplit, IoTDBSourceState> {
    private static final Logger log = LoggerFactory.getLogger(IoTDBSourceSplitEnumerator.class);
    private static final int SQL_WHERE_SPLIT_LENGTH = 2;
    private final Object stateLock = new Object();
    private final SourceSplitEnumerator.Context<IoTDBSourceSplit> context;
    private final Map<String, Object> conf;
    private final Map<Integer, List<IoTDBSourceSplit>> pendingSplit;
    private volatile boolean shouldEnumerate;

    public IoTDBSourceSplitEnumerator(SourceSplitEnumerator.Context<IoTDBSourceSplit> context, Map<String, Object> conf) {
        this(context, conf, null);
    }

    public IoTDBSourceSplitEnumerator(SourceSplitEnumerator.Context<IoTDBSourceSplit> context, Map<String, Object> conf, IoTDBSourceState sourceState) {
        this.context = context;
        this.conf = conf;
        this.pendingSplit = new HashMap<Integer, List<IoTDBSourceSplit>>();
        boolean bl = this.shouldEnumerate = sourceState == null;
        if (sourceState != null) {
            this.shouldEnumerate = sourceState.isShouldEnumerate();
            this.pendingSplit.putAll(sourceState.getPendingSplit());
        }
    }

    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Set readers = this.context.registeredReaders();
        if (this.shouldEnumerate) {
            Set<IoTDBSourceSplit> newSplits = this.getIotDBSplit();
            Object object = this.stateLock;
            synchronized (object) {
                this.addPendingSplit(newSplits);
                this.shouldEnumerate = false;
            }
            this.assignSplit(readers);
        }
        log.debug("No more splits to assign. Sending NoMoreSplitsEvent to reader {}.", (Object)readers);
        readers.forEach(arg_0 -> this.context.signalNoMoreSplits(arg_0));
    }

    private Set<IoTDBSourceSplit> getIotDBSplit() {
        String sql = this.conf.get(SourceConfig.SQL.key()).toString();
        HashSet<IoTDBSourceSplit> iotDBSourceSplits = new HashSet<IoTDBSourceSplit>();
        if (!this.conf.containsKey(SourceConfig.NUM_PARTITIONS.key())) {
            iotDBSourceSplits.add(new IoTDBSourceSplit("0", sql));
            return iotDBSourceSplits;
        }
        long start = Long.parseLong(this.conf.get(SourceConfig.LOWER_BOUND.key()).toString());
        long end = Long.parseLong(this.conf.get(SourceConfig.UPPER_BOUND.key()).toString());
        int numPartitions = Integer.parseInt(this.conf.get(SourceConfig.NUM_PARTITIONS.key()).toString());
        String sqlBase = sql;
        String sqlAlign = null;
        String sqlCondition = null;
        String[] sqls = sqlBase.split("(?i)align by");
        if (sqls.length > 1) {
            sqlBase = sqls[0];
            sqlAlign = sqls[1];
        }
        if ((sqls = sqlBase.split("(?i)where")).length > 2) {
            throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, "sql should not contain more than one where");
        }
        if (sqls.length > 1) {
            sqlBase = sqls[0];
            sqlCondition = sqls[1];
        }
        long size = (end - start) / (long)numPartitions + 1L;
        long remainder = (end + 1L - start) % (long)numPartitions;
        if (end - start < (long)numPartitions) {
            numPartitions = (int)(end - start);
        }
        long currentStart = start;
        int i = 0;
        while (i < numPartitions) {
            String query = " where (time >= " + currentStart + " and " + "time" + " < " + (currentStart + size) + ") ";
            currentStart += size;
            if (++i + 1 <= numPartitions) {
                currentStart -= remainder;
            }
            query = sqlBase + query;
            if (!Strings.isNullOrEmpty((String)sqlCondition)) {
                query = query + " and ( " + sqlCondition + " ) ";
            }
            if (!Strings.isNullOrEmpty((String)sqlAlign)) {
                query = query + " align by " + sqlAlign;
            }
            iotDBSourceSplits.add(new IoTDBSourceSplit(String.valueOf(query.hashCode()), query));
        }
        return iotDBSourceSplits;
    }

    public void addSplitsBack(List<IoTDBSourceSplit> splits, int subtaskId) {
        log.debug("Add back splits {} to IoTDBSourceSplitEnumerator.", splits);
        if (!splits.isEmpty()) {
            this.addPendingSplit(splits);
            this.assignSplit(Collections.singletonList(subtaskId));
        }
    }

    public int currentUnassignedSplitSize() {
        return this.pendingSplit.size();
    }

    public void registerReader(int subtaskId) {
        log.debug("Register reader {} to IoTDBSourceSplitEnumerator.", (Object)subtaskId);
        if (!this.pendingSplit.isEmpty()) {
            this.assignSplit(Collections.singletonList(subtaskId));
        }
    }

    private void addPendingSplit(Collection<IoTDBSourceSplit> splits) {
        int readerCount = this.context.currentParallelism();
        for (IoTDBSourceSplit split : splits) {
            int ownerReader = IoTDBSourceSplitEnumerator.getSplitOwner(split.splitId(), readerCount);
            log.info("Assigning {} to {} reader.", (Object)split, (Object)ownerReader);
            this.pendingSplit.computeIfAbsent(ownerReader, r -> new ArrayList()).add(split);
        }
    }

    private void assignSplit(Collection<Integer> readers) {
        log.debug("Assign pendingSplits to readers {}", readers);
        for (int reader : readers) {
            List<IoTDBSourceSplit> assignmentForReader = this.pendingSplit.remove(reader);
            if (assignmentForReader == null || assignmentForReader.isEmpty()) continue;
            log.info("Assign splits {} to reader {}", assignmentForReader, (Object)reader);
            try {
                this.context.assignSplit(reader, assignmentForReader);
            }
            catch (Exception e) {
                log.error("Failed to assign splits {} to reader {}", new Object[]{assignmentForReader, reader, e});
                this.pendingSplit.put(reader, assignmentForReader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoTDBSourceState snapshotState(long checkpointId) throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            return new IoTDBSourceState(this.shouldEnumerate, this.pendingSplit);
        }
    }

    private static int getSplitOwner(String tp, int numReaders) {
        return (tp.hashCode() & Integer.MAX_VALUE) % numReaders;
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }

    public void close() {
    }

    public void handleSplitRequest(int subtaskId) {
        throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Unsupported handleSplitRequest: %d", subtaskId));
    }
}

