/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iotdb.source;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.iotdb.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.iotdb.exception.IotdbConnectorException;
import org.apache.seatunnel.connectors.seatunnel.iotdb.source.IoTDBSourceReader;
import org.apache.seatunnel.connectors.seatunnel.iotdb.source.IoTDBSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.iotdb.source.IoTDBSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iotdb.state.IoTDBSourceState;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;

@AutoService(value={SeaTunnelSource.class})
public class IoTDBSource
implements SeaTunnelSource<SeaTunnelRow, IoTDBSourceSplit, IoTDBSourceState>,
SupportParallelism,
SupportColumnProjection {
    private JobContext jobContext;
    private SeaTunnelRowType typeInfo;
    private final Map<String, Object> configParams = new HashMap<String, Object>();

    public String getPluginName() {
        return "IoTDB";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        CheckResult urlCheckResult = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{SourceConfig.HOST.key(), SourceConfig.PORT.key()});
        if (!urlCheckResult.isSuccess()) {
            urlCheckResult = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{SourceConfig.NODE_URLS.key()});
        }
        CheckResult schemaCheckResult = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{CatalogTableUtil.SCHEMA.key()});
        CheckResult mergedConfigCheck = CheckConfigUtil.mergeCheckResults((CheckResult[])new CheckResult[]{urlCheckResult, schemaCheckResult});
        if (!mergedConfigCheck.isSuccess()) {
            throw new IotdbConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SOURCE, mergedConfigCheck.getMsg()));
        }
        this.typeInfo = CatalogTableUtil.buildWithConfig((Config)pluginConfig).getSeaTunnelRowType();
        pluginConfig.entrySet().forEach(entry -> this.configParams.put((String)entry.getKey(), ((ConfigValue)entry.getValue()).unwrapped()));
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.typeInfo;
    }

    public SourceReader<SeaTunnelRow, IoTDBSourceSplit> createReader(SourceReader.Context readerContext) {
        return new IoTDBSourceReader(this.configParams, readerContext, this.typeInfo);
    }

    public SourceSplitEnumerator<IoTDBSourceSplit, IoTDBSourceState> createEnumerator(SourceSplitEnumerator.Context<IoTDBSourceSplit> enumeratorContext) throws Exception {
        return new IoTDBSourceSplitEnumerator(enumeratorContext, this.configParams);
    }

    public SourceSplitEnumerator<IoTDBSourceSplit, IoTDBSourceState> restoreEnumerator(SourceSplitEnumerator.Context<IoTDBSourceSplit> enumeratorContext, IoTDBSourceState checkpointState) throws Exception {
        return new IoTDBSourceSplitEnumerator(enumeratorContext, this.configParams, checkpointState);
    }
}

