/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v2.read.reader.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.encoding.decoder.PlainDecoder;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.utils.Binary;

public class PageReaderV2
extends PageReader {
    public PageReaderV2(ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder, Filter filter) {
        this(null, pageData, dataType, valueDecoder, timeDecoder, filter);
    }

    public PageReaderV2(PageHeader pageHeader, ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder, Filter filter) {
        super(pageHeader, pageData, dataType, valueDecoder, timeDecoder, filter);
    }

    @Override
    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        if (this.dataType != TSDataType.INT32 && this.dataType != TSDataType.TEXT) {
            return super.getAllSatisfiedPageData(ascending);
        }
        BatchData pageData = BatchDataFactory.createBatchData(this.dataType, ascending, false);
        block4: while (this.timeDecoder.hasNext(this.timeBuffer)) {
            long timestamp = this.timeDecoder.readLong(this.timeBuffer);
            switch (this.dataType) {
                case INT32: {
                    int anInt;
                    int n = anInt = this.valueDecoder instanceof PlainDecoder ? this.valueBuffer.getInt() : this.valueDecoder.readInt(this.valueBuffer);
                    if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, anInt)) continue block4;
                    pageData.putInt(timestamp, anInt);
                    continue block4;
                }
                case TEXT: {
                    int length = this.valueBuffer.getInt();
                    byte[] buf = new byte[length];
                    this.valueBuffer.get(buf, 0, buf.length);
                    Binary aBinary = new Binary(buf);
                    if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aBinary)) continue block4;
                    pageData.putBinary(timestamp, aBinary);
                    continue block4;
                }
            }
            throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
        }
        return pageData.flip();
    }
}

