/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.dataset;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public abstract class QueryDataSet {
    protected List<Path> paths;
    protected List<TSDataType> dataTypes;
    protected int rowLimit = 0;
    protected int rowOffset = 0;
    protected int alreadyReturnedRowNum = 0;
    protected int fetchSize = 10000;
    protected boolean ascending;
    protected EndPoint endPoint = null;
    protected boolean withoutAnyNull;
    protected boolean withoutAllNull;
    protected Set<Integer> withoutNullColumnsIndex;
    protected int columnNum;

    public QueryDataSet() {
    }

    public QueryDataSet(List<Path> paths, List<TSDataType> dataTypes) {
        this.initQueryDataSetFields(paths, dataTypes, true);
    }

    public QueryDataSet(List<Path> paths, List<TSDataType> dataTypes, boolean ascending) {
        this.initQueryDataSetFields(paths, dataTypes, ascending);
    }

    protected void initQueryDataSetFields(List<Path> paths, List<TSDataType> dataTypes, boolean ascending) {
        this.paths = paths;
        this.dataTypes = dataTypes;
        this.ascending = ascending;
        this.columnNum = 0;
        if (paths != null) {
            for (Path p : paths) {
                this.columnNum += p.getColumnNum();
            }
        }
    }

    public Set<Integer> getWithoutNullColumnsIndex() {
        return this.withoutNullColumnsIndex;
    }

    public void setWithoutNullColumnsIndex(Set<Integer> withoutNullColumnsIndex) {
        this.withoutNullColumnsIndex = withoutNullColumnsIndex;
    }

    public boolean hasNext() throws IOException {
        while (this.rowOffset > 0) {
            if (this.hasNextWithoutConstraint()) {
                RowRecord rowRecord = this.nextWithoutConstraint();
                if (this.withoutNullFilter(rowRecord)) continue;
                --this.rowOffset;
                continue;
            }
            return false;
        }
        if (this.rowLimit > 0 && this.alreadyReturnedRowNum >= this.rowLimit) {
            return false;
        }
        return this.hasNextWithoutConstraint();
    }

    public boolean withoutNullFilter(RowRecord rowRecord) {
        boolean allNullFlag;
        boolean anyNullFlag = this.withoutNullColumnsIndex == null ? rowRecord.hasNullField() : this.withoutNullColumnsIndex.isEmpty() && rowRecord.hasNullField();
        boolean bl = allNullFlag = this.withoutNullColumnsIndex != null || rowRecord.isAllNull();
        if (this.withoutNullColumnsIndex != null) {
            for (int index : this.withoutNullColumnsIndex) {
                Field field = rowRecord.getFields().get(index);
                if (field == null || field.getDataType() == null) {
                    anyNullFlag = true;
                    if (!this.withoutAnyNull) continue;
                    break;
                }
                allNullFlag = false;
                if (!this.withoutAllNull) continue;
                break;
            }
        }
        if (this.withoutNullColumnsIndex != null && this.withoutNullColumnsIndex.isEmpty()) {
            allNullFlag = rowRecord.isAllNull();
        }
        return this.withoutAllNull && allNullFlag || this.withoutAnyNull && anyNullFlag;
    }

    public abstract boolean hasNextWithoutConstraint() throws IOException;

    public RowRecord next() throws IOException {
        if (this.rowLimit > 0) {
            ++this.alreadyReturnedRowNum;
        }
        return this.nextWithoutConstraint();
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public abstract RowRecord nextWithoutConstraint() throws IOException;

    public List<Path> getPaths() {
        return this.paths;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public boolean hasLimit() {
        return this.rowLimit > 0;
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(EndPoint endPoint) {
        this.endPoint = endPoint;
    }

    public boolean isWithoutAnyNull() {
        return this.withoutAnyNull;
    }

    public void setWithoutAnyNull(boolean withoutAnyNull) {
        this.withoutAnyNull = withoutAnyNull;
    }

    public boolean isWithoutAllNull() {
        return this.withoutAllNull;
    }

    public void setWithoutAllNull(boolean withoutAllNull) {
        this.withoutAllNull = withoutAllNull;
    }

    public void decreaseAlreadyReturnedRowNum() {
        --this.alreadyReturnedRowNum;
    }

    public int getColumnNum() {
        return this.columnNum;
    }

    public static class EndPoint {
        private String ip = null;
        private int port = 0;

        public EndPoint(String ip, int port) {
            this.ip = ip;
            this.port = port;
        }

        public EndPoint() {
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String toString() {
            return "ip:port=" + this.ip + ":" + this.port;
        }
    }
}

