/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.fileSystem.fileInputFactory;

import java.io.IOException;
import java.nio.file.Paths;
import org.apache.iotdb.tsfile.fileSystem.fileInputFactory.FileInputFactory;
import org.apache.iotdb.tsfile.read.reader.LocalTsFileInput;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFSInputFactory
implements FileInputFactory {
    private static final Logger logger = LoggerFactory.getLogger(LocalFSInputFactory.class);

    @Override
    public TsFileInput getTsFileInput(String filePath) {
        try {
            return new LocalTsFileInput(Paths.get(filePath, new String[0]));
        }
        catch (IOException e) {
            logger.error("Failed to get TsFile input of file: {}, ", (Object)filePath, (Object)e);
            return null;
        }
    }
}

