/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.influxdb.config;

import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.InfluxDBConfig;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.TimePrecision;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class SinkConfig
extends InfluxDBConfig {
    public static final Option<String> KEY_TIME = Options.key((String)"key_time").stringType().noDefaultValue().withDescription("the influxdb server key time");
    public static final Option<List<String>> KEY_TAGS = Options.key((String)"key_tags").listType().noDefaultValue().withDescription("the influxdb server key tags");
    public static final Option<String> KEY_MEASUREMENT = Options.key((String)"measurement").stringType().noDefaultValue().withDescription("the influxdb server measurement");
    public static final Option<Integer> BATCH_SIZE = Options.key((String)"batch_size").intType().defaultValue((Object)1024).withDescription("batch size of the influxdb client");
    public static final Option<Integer> MAX_RETRIES = Options.key((String)"max_retries").intType().noDefaultValue().withDescription("max retries of the influxdb client");
    public static final Option<Integer> WRITE_TIMEOUT = Options.key((String)"write_timeout").intType().defaultValue((Object)5).withDescription("the influxdb client write data timeout");
    public static final Option<Integer> RETRY_BACKOFF_MULTIPLIER_MS = Options.key((String)"retry_backoff_multiplier_ms").intType().noDefaultValue().withDescription("the influxdb client retry backoff multiplier ms");
    public static final Option<Integer> MAX_RETRY_BACKOFF_MS = Options.key((String)"max_retry_backoff_ms").intType().noDefaultValue().withDescription("the influxdb client max retry backoff ms");
    public static final Option<String> RETENTION_POLICY = Options.key((String)"rp").stringType().noDefaultValue().withDescription("the influxdb client retention policy");
    private static final TimePrecision DEFAULT_TIME_PRECISION = TimePrecision.NS;
    private String rp;
    private String measurement;
    private int writeTimeout = (Integer)WRITE_TIMEOUT.defaultValue();
    private String keyTime;
    private List<String> keyTags;
    private int batchSize = (Integer)BATCH_SIZE.defaultValue();
    private int maxRetries;
    private int retryBackoffMultiplierMs;
    private int maxRetryBackoffMs;
    private TimePrecision precision = DEFAULT_TIME_PRECISION;

    public SinkConfig(Config config) {
        super(config);
        this.loadConfig(config);
    }

    public void loadConfig(Config config) {
        if (config.hasPath(KEY_TIME.key())) {
            this.setKeyTime(config.getString(KEY_TIME.key()));
        }
        if (config.hasPath(KEY_TAGS.key())) {
            this.setKeyTags(config.getStringList(KEY_TAGS.key()));
        }
        if (config.hasPath(MAX_RETRIES.key())) {
            this.setMaxRetries(config.getInt(MAX_RETRIES.key()));
        }
        if (config.hasPath(RETRY_BACKOFF_MULTIPLIER_MS.key())) {
            this.setRetryBackoffMultiplierMs(config.getInt(RETRY_BACKOFF_MULTIPLIER_MS.key()));
        }
        if (config.hasPath(MAX_RETRY_BACKOFF_MS.key())) {
            this.setMaxRetryBackoffMs(config.getInt(MAX_RETRY_BACKOFF_MS.key()));
        }
        if (config.hasPath(WRITE_TIMEOUT.key())) {
            this.setWriteTimeout(config.getInt(WRITE_TIMEOUT.key()));
        }
        if (config.hasPath(RETENTION_POLICY.key())) {
            this.setRp(config.getString(RETENTION_POLICY.key()));
        }
        if (config.hasPath(EPOCH.key())) {
            this.setPrecision(TimePrecision.getPrecision(config.getString(EPOCH.key())));
        }
        this.setMeasurement(config.getString(KEY_MEASUREMENT.key()));
    }

    public void setRp(String rp) {
        this.rp = rp;
    }

    public void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setKeyTime(String keyTime) {
        this.keyTime = keyTime;
    }

    public void setKeyTags(List<String> keyTags) {
        this.keyTags = keyTags;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRetryBackoffMultiplierMs(int retryBackoffMultiplierMs) {
        this.retryBackoffMultiplierMs = retryBackoffMultiplierMs;
    }

    public void setMaxRetryBackoffMs(int maxRetryBackoffMs) {
        this.maxRetryBackoffMs = maxRetryBackoffMs;
    }

    public void setPrecision(TimePrecision precision) {
        this.precision = precision;
    }

    public String getRp() {
        return this.rp;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public String getKeyTime() {
        return this.keyTime;
    }

    public List<String> getKeyTags() {
        return this.keyTags;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRetryBackoffMultiplierMs() {
        return this.retryBackoffMultiplierMs;
    }

    public int getMaxRetryBackoffMs() {
        return this.maxRetryBackoffMs;
    }

    public TimePrecision getPrecision() {
        return this.precision;
    }

    @Override
    public String toString() {
        return "SinkConfig(rp=" + this.getRp() + ", measurement=" + this.getMeasurement() + ", writeTimeout=" + this.getWriteTimeout() + ", keyTime=" + this.getKeyTime() + ", keyTags=" + this.getKeyTags() + ", batchSize=" + this.getBatchSize() + ", maxRetries=" + this.getMaxRetries() + ", retryBackoffMultiplierMs=" + this.getRetryBackoffMultiplierMs() + ", maxRetryBackoffMs=" + this.getMaxRetryBackoffMs() + ", precision=" + (Object)((Object)this.getPrecision()) + ")";
    }
}

