/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.influxdb.sink;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.SinkConnectorCommonOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.InfluxDBSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.influxdb.sink.InfluxDBSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Factory.class})
public class InfluxDBSinkFactory
implements TableSinkFactory {
    private static final Logger log = LoggerFactory.getLogger(InfluxDBSinkFactory.class);

    public String factoryIdentifier() {
        return "InfluxDB";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{InfluxDBSinkOptions.URL, InfluxDBSinkOptions.DATABASES}).bundled(new Option[]{InfluxDBSinkOptions.USERNAME, InfluxDBSinkOptions.PASSWORD}).optional(new Option[]{InfluxDBSinkOptions.CONNECT_TIMEOUT_MS, InfluxDBSinkOptions.KEY_MEASUREMENT, InfluxDBSinkOptions.KEY_TAGS, InfluxDBSinkOptions.KEY_TIME, InfluxDBSinkOptions.BATCH_SIZE, InfluxDBSinkOptions.MAX_RETRIES, InfluxDBSinkOptions.WRITE_TIMEOUT, InfluxDBSinkOptions.RETRY_BACKOFF_MULTIPLIER_MS, InfluxDBSinkOptions.MAX_RETRY_BACKOFF_MS, InfluxDBSinkOptions.RETENTION_POLICY, InfluxDBSinkOptions.QUERY_TIMEOUT_SEC, InfluxDBSinkOptions.EPOCH, SinkConnectorCommonOptions.MULTI_TABLE_SINK_REPLICA}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        ReadonlyConfig config = context.getOptions();
        CatalogTable catalogTable = context.getCatalogTable();
        if (!config.getOptional(InfluxDBSinkOptions.KEY_MEASUREMENT).isPresent()) {
            Map map = config.toMap();
            map.put(InfluxDBSinkOptions.KEY_MEASUREMENT.key(), catalogTable.getTableId().toTablePath().getFullName());
            config = ReadonlyConfig.fromMap(new HashMap(map));
        }
        SinkConfig sinkConfig = new SinkConfig(config);
        return () -> new InfluxDBSink(sinkConfig, catalogTable);
    }
}

