/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.google.sheets.source;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.config.SheetsConfig;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.config.SheetsParameters;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.exception.GoogleSheetsConnectorException;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.source.SheetsSourceReader;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSource.class})
public class SheetsSource
extends AbstractSingleSplitSource<SeaTunnelRow> {
    private SeaTunnelRowType seaTunnelRowType;
    private CatalogTable catalogTable;
    private SheetsParameters sheetsParameters;
    private DeserializationSchema<SeaTunnelRow> deserializationSchema;

    public String getPluginName() {
        return "GoogleSheets";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        CheckResult checkResult = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{SheetsConfig.SERVICE_ACCOUNT_KEY.key(), SheetsConfig.SHEET_ID.key(), SheetsConfig.SHEET_NAME.key(), SheetsConfig.RANGE.key(), TableSchemaOptions.SCHEMA.key()});
        if (!checkResult.isSuccess()) {
            throw new GoogleSheetsConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SOURCE, checkResult.getMsg()));
        }
        this.sheetsParameters = new SheetsParameters().buildWithConfig(pluginConfig);
        this.catalogTable = pluginConfig.hasPath(TableSchemaOptions.SCHEMA.key()) ? CatalogTableUtil.buildWithConfig((Config)pluginConfig) : CatalogTableUtil.buildSimpleTextTable();
        this.seaTunnelRowType = this.catalogTable.getSeaTunnelRowType();
        this.deserializationSchema = new JsonDeserializationSchema(this.catalogTable, false, false);
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.seaTunnelRowType;
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) throws Exception {
        return new SheetsSourceReader(this.sheetsParameters, readerContext, this.deserializationSchema, this.seaTunnelRowType);
    }
}

