/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.sink;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.sink.ElasticsearchSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.state.ElasticsearchAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.state.ElasticsearchCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.state.ElasticsearchSinkState;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSink.class})
public class ElasticsearchSink
implements SeaTunnelSink<SeaTunnelRow, ElasticsearchSinkState, ElasticsearchCommitInfo, ElasticsearchAggregatedCommitInfo> {
    private Config pluginConfig;
    private SeaTunnelRowType seaTunnelRowType;
    private int maxBatchSize = (Integer)SinkConfig.MAX_BATCH_SIZE.defaultValue();
    private int maxRetryCount = (Integer)SinkConfig.MAX_RETRY_COUNT.defaultValue();

    public String getPluginName() {
        return "Elasticsearch";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        this.pluginConfig = pluginConfig;
        if (pluginConfig.hasPath(SinkConfig.MAX_BATCH_SIZE.key())) {
            this.maxBatchSize = pluginConfig.getInt(SinkConfig.MAX_BATCH_SIZE.key());
        }
        if (pluginConfig.hasPath(SinkConfig.MAX_RETRY_COUNT.key())) {
            this.maxRetryCount = pluginConfig.getInt(SinkConfig.MAX_RETRY_COUNT.key());
        }
    }

    public void setTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    public SeaTunnelDataType<SeaTunnelRow> getConsumedType() {
        return this.seaTunnelRowType;
    }

    public SinkWriter<SeaTunnelRow, ElasticsearchCommitInfo, ElasticsearchSinkState> createWriter(SinkWriter.Context context) {
        return new ElasticsearchSinkWriter(context, this.seaTunnelRowType, this.pluginConfig, this.maxBatchSize, this.maxRetryCount);
    }
}

