/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.datahub.sink;

import com.google.auto.service.AutoService;
import java.io.IOException;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.datahub.config.DataHubConfig;
import org.apache.seatunnel.connectors.seatunnel.datahub.exception.DataHubConnectorException;
import org.apache.seatunnel.connectors.seatunnel.datahub.sink.DataHubWriter;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSink.class})
public class DataHubSink
extends AbstractSimpleSink<SeaTunnelRow, Void> {
    private Config pluginConfig;
    private SeaTunnelRowType seaTunnelRowType;

    public String getPluginName() {
        return "DataHub";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        CheckResult result = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{DataHubConfig.ENDPOINT.key(), DataHubConfig.ACCESS_ID.key(), DataHubConfig.ACCESS_KEY.key(), DataHubConfig.PROJECT.key(), DataHubConfig.TOPIC.key()});
        if (!result.isSuccess()) {
            throw new DataHubConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SINK, result.getMsg()));
        }
        this.pluginConfig = pluginConfig;
    }

    public void setTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    @Override
    public AbstractSinkWriter<SeaTunnelRow, Void> createWriter(SinkWriter.Context context) throws IOException {
        return new DataHubWriter(this.seaTunnelRowType, this.pluginConfig.getString(DataHubConfig.ENDPOINT.key()), this.pluginConfig.getString(DataHubConfig.ACCESS_ID.key()), this.pluginConfig.getString(DataHubConfig.ACCESS_KEY.key()), this.pluginConfig.getString(DataHubConfig.PROJECT.key()), this.pluginConfig.getString(DataHubConfig.TOPIC.key()), this.pluginConfig.getInt(DataHubConfig.TIMEOUT.key()), this.pluginConfig.getInt(DataHubConfig.RETRY_TIMES.key()));
    }
}

