/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.model.protobuf;

import com.aliyun.datahub.client.http.converter.BaseProtobufModel;
import com.aliyun.datahub.client.http.converter.batch.BatchUtil;
import com.aliyun.datahub.client.model.GetRecordsResult;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.RecordRespMeta;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.protobuf.DatahubProtos;
import com.aliyun.datahub.shaded.com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;

public class GetBatchRecordsResultPB
extends GetRecordsResult
implements BaseProtobufModel {
    private DatahubProtos.GetBinaryRecordsResponse proto;
    private RecordSchema schema;
    private String shardId;

    @Override
    public String getNextCursor() {
        return this.proto.getNextCursor();
    }

    @Override
    public int getRecordCount() {
        return this.proto.getRecordCount();
    }

    @Override
    public long getStartSequence() {
        return this.proto.getStartSequence();
    }

    @Override
    public long getLatestSequence() {
        return this.proto.getLatestSequence();
    }

    @Override
    public long getLatestTime() {
        return this.proto.getLatestTime();
    }

    @Override
    public synchronized List<RecordEntry> getRecords() {
        if (this.records == null) {
            this.records = new ArrayList();
            for (DatahubProtos.BinaryRecordEntry entry : this.proto.getRecordsList()) {
                this.records.addAll(this.convertFromBatchRecord(entry));
            }
        }
        return this.records;
    }

    public void internalSetSchema(RecordSchema schema) {
        this.schema = schema;
    }

    public void internalSetShardId(String shardId) {
        this.shardId = shardId;
    }

    @Override
    public String getContentType() {
        return "application/x-binary";
    }

    @Override
    public Message getMessage() {
        return null;
    }

    @Override
    public void setMessage(Message message) {
        this.proto = (DatahubProtos.GetBinaryRecordsResponse)message;
    }

    private List<RecordEntry> convertFromBatchRecord(final DatahubProtos.BinaryRecordEntry binaryRecordPB) {
        byte[] data = binaryRecordPB.getData().toByteArray();
        RecordRespMeta respMeta = new RecordRespMeta(){
            {
                this.setCursor(binaryRecordPB.getCursor());
                this.setNextCursor(binaryRecordPB.getNextCursor());
                this.setSequence(binaryRecordPB.getSequence());
                this.setSystemTime(binaryRecordPB.getSystemTime());
                this.setLatestSequence(this.getLatestSequence());
                this.setLatestTime(this.getLatestTime());
            }
        };
        return BatchUtil.deserialize(data, respMeta, this.schema);
    }

    public static Message.Builder newBuilder() {
        return DatahubProtos.GetBinaryRecordsResponse.newBuilder();
    }
}

