/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.serializer;

import com.aliyun.datahub.client.model.AlarmLevel;
import com.aliyun.datahub.client.model.AlarmRule;
import com.aliyun.datahub.client.model.AlarmRuleEntry;
import com.aliyun.datahub.client.model.AlarmType;
import com.aliyun.datahub.client.model.ConnectorDoneDelayAlarmRule;
import com.aliyun.datahub.client.model.SubReadDelayAlarmRule;
import com.aliyun.datahub.client.model.TopicNoDataAlarmRule;
import com.aliyun.datahub.client.util.JsonUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AlarmRuleEntryDeserializer
extends JsonDeserializer<AlarmRuleEntry> {
    @Override
    public AlarmRuleEntry deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        AlarmRuleEntry result = new AlarmRuleEntry();
        AlarmRuleEntryDeserializer.deserialize(result, jsonParser);
        return result;
    }

    public static void deserialize(AlarmRuleEntry alarmRuleEntry, JsonParser jsonParser) throws IOException, JsonProcessingException {
        JsonNode tree = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode node = tree.get("RegionId");
        if (node != null && !node.isNull()) {
            alarmRuleEntry.setRegionId(node.asText());
        }
        if ((node = tree.get("AlarmId")) != null && !node.isNull()) {
            alarmRuleEntry.setAlarmId(node.asText());
        }
        if ((node = tree.get("ProjectName")) != null && !node.isNull()) {
            alarmRuleEntry.setProjectName(node.asText());
        }
        if ((node = tree.get("TopicName")) != null && !node.isNull()) {
            alarmRuleEntry.setTopicName(node.asText());
        }
        if ((node = tree.get("Uid")) != null && !node.isNull()) {
            alarmRuleEntry.setUid(node.asText());
        }
        if ((node = tree.get("AlarmType")) != null && !node.isNull()) {
            alarmRuleEntry.setAlarmType(AlarmType.fromString(node.asText()));
        }
        if ((node = tree.get("CreateTime")) != null && !node.isNull()) {
            alarmRuleEntry.setCreateTime(node.asInt());
        }
        if ((node = tree.get("UpdateTime")) != null && !node.isNull()) {
            alarmRuleEntry.setUpdateTime(node.asInt());
        }
        if ((node = tree.get("Rule")) != null && !node.isNull()) {
            alarmRuleEntry.setRule(AlarmRuleEntryDeserializer.deserializeAlarmRule(alarmRuleEntry.getAlarmType(), node));
        }
        if ((node = tree.get("Config")) != null && node.isObject()) {
            HashMap<String, String> config = new HashMap<String, String>();
            Iterator<Map.Entry<String, JsonNode>> iter = node.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> entry = iter.next();
                if (entry.getValue() == null || !entry.getValue().isTextual()) continue;
                config.put(entry.getKey(), entry.getValue().asText());
            }
            alarmRuleEntry.setConfig(config);
        }
    }

    private static AlarmRule deserializeAlarmRule(AlarmType type, JsonNode tree) throws IOException {
        JsonNode fNode;
        AlarmRule alarmRule;
        if (AlarmType.USER_TOPIC_NO_DATA.equals((Object)type)) {
            alarmRule = AlarmRuleEntryDeserializer.deserializeTopicNoDataAlarmRule(tree);
        } else if (AlarmType.USER_SUB_READ_DELAY.equals((Object)type)) {
            alarmRule = AlarmRuleEntryDeserializer.deserializeSubReadDelayAlarmRule(tree);
        } else if (AlarmType.USER_CONNECTOR_DONE_DELAY.equals((Object)type)) {
            alarmRule = AlarmRuleEntryDeserializer.deserializeConnectorDoneDelayAlarmRule(tree);
        } else {
            throw new IOException("unknown alarm type");
        }
        JsonNode node = tree.get("Level");
        if (node != null && !node.isNull()) {
            alarmRule.setLevel(AlarmLevel.fromString(node.asText()));
        }
        if ((node = tree.get("Phone")) != null && node.isTextual() && (fNode = JsonUtils.toJsonNode(node.asText())) != null && fNode.isArray()) {
            ArrayList<String> phoneList = new ArrayList<String>();
            for (JsonNode temp : fNode) {
                phoneList.add(temp.asText());
            }
            alarmRule.setPhoneList(phoneList);
        }
        if ((node = tree.get("Mail")) != null && node.isTextual() && (fNode = JsonUtils.toJsonNode(node.asText())) != null && fNode.isArray()) {
            ArrayList<String> mailList = new ArrayList<String>();
            for (JsonNode temp : fNode) {
                mailList.add(temp.asText());
            }
            alarmRule.setMailList(mailList);
        }
        if ((node = tree.get("EmpId")) != null && node.isTextual() && (fNode = JsonUtils.toJsonNode(node.asText())) != null && fNode.isArray()) {
            ArrayList<String> empIdList = new ArrayList<String>();
            for (JsonNode temp : fNode) {
                empIdList.add(temp.asText());
            }
            alarmRule.setEmpIdList(empIdList);
        }
        return alarmRule;
    }

    private static AlarmRule deserializeTopicNoDataAlarmRule(JsonNode tree) {
        TopicNoDataAlarmRule alarmRule = new TopicNoDataAlarmRule();
        JsonNode node = tree.get("SuspendSecond");
        if (node != null && !node.isNull()) {
            alarmRule.setSuspendSecond(Integer.parseInt(node.asText()));
        }
        return alarmRule;
    }

    private static AlarmRule deserializeSubReadDelayAlarmRule(JsonNode tree) {
        SubReadDelayAlarmRule alarmRule = new SubReadDelayAlarmRule();
        JsonNode node = tree.get("SubId");
        if (node != null && !node.isNull()) {
            alarmRule.setSubId(node.asText());
        }
        if ((node = tree.get("DelaySecond")) != null && !node.isNull()) {
            alarmRule.setDelaySecond(Integer.parseInt(node.asText()));
        }
        return alarmRule;
    }

    private static AlarmRule deserializeConnectorDoneDelayAlarmRule(JsonNode tree) {
        ConnectorDoneDelayAlarmRule alarmRule = new ConnectorDoneDelayAlarmRule();
        JsonNode node = tree.get("ConnectorId");
        if (node != null && !node.isNull()) {
            alarmRule.setConnectorId(node.asText());
        }
        if ((node = tree.get("DelaySecond")) != null && !node.isNull()) {
            alarmRule.setDelaySecond(Integer.parseInt(node.asText()));
        }
        return alarmRule;
    }
}

