/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http.interceptor.compress;

import com.aliyun.datahub.client.http.interceptor.HttpInterceptor;
import com.aliyun.datahub.client.http.interceptor.compress.RequestBodyWrapper;
import com.aliyun.datahub.shaded.okhttp3.Interceptor;
import com.aliyun.datahub.shaded.okhttp3.Request;
import com.aliyun.datahub.shaded.okhttp3.RequestBody;
import com.aliyun.datahub.shaded.okhttp3.Response;
import com.aliyun.datahub.shaded.okhttp3.ResponseBody;
import com.aliyun.datahub.shaded.okio.Buffer;
import com.aliyun.datahub.shaded.org.apache.commons.io.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;

public class Lz4RequestInterceptor
extends HttpInterceptor {
    private static final LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
    private static final LZ4SafeDecompressor decompressor = LZ4Factory.fastestInstance().safeDecompressor();

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(this.compressRequest(chain.request()));
        return this.decompressResponse(response);
    }

    private Request compressRequest(Request request) throws IOException {
        if (request.body() == null || request.header("Content-Encoding") != null) {
            return request;
        }
        RequestBodyWrapper wrapper = this.compressBody(request.body());
        return request.newBuilder().header("Content-Encoding", "lz4").header("Accept-Encoding", "lz4").header("x-datahub-content-raw-size", String.valueOf(wrapper.getRawSize())).method(request.method(), wrapper.getBody()).build();
    }

    private RequestBodyWrapper compressBody(RequestBody body) throws IOException {
        Buffer buffer = new Buffer();
        body.writeTo(buffer);
        long rawSize = buffer.size();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        buffer.copyTo(out);
        byte[] compressBuffer = compressor.compress(out.toByteArray());
        return new RequestBodyWrapper(rawSize, RequestBody.create(body.contentType(), compressBuffer));
    }

    private Response decompressResponse(Response response) throws IOException {
        if (response.body() == null || response.header("Content-Encoding") == null) {
            return response;
        }
        String rawSizeStr = response.header("x-datahub-content-raw-size");
        if (rawSizeStr == null) {
            return response;
        }
        return response.newBuilder().removeHeader("Content-Encoding").body(this.decompressBody(Integer.valueOf(rawSizeStr), response.body())).build();
    }

    private ResponseBody decompressBody(int rawSize, ResponseBody body) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy(body.byteStream(), (OutputStream)out);
        byte[] restored = new byte[rawSize];
        int size = decompressor.decompress(out.toByteArray(), restored);
        return ResponseBody.create(body.contentType(), Arrays.copyOfRange(restored, 0, size));
    }
}

