/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http.common;

import com.aliyun.datahub.client.http.common.HttpEntity;
import com.aliyun.datahub.client.http.common.HttpForm;
import com.aliyun.datahub.client.http.common.HttpInterceptor;
import com.aliyun.datahub.client.http.common.HttpMethod;
import com.aliyun.datahub.client.http.common.HttpResponse;
import com.aliyun.datahub.client.util.JsonUtils;
import com.aliyun.datahub.shaded.okhttp3.HttpUrl;
import com.aliyun.datahub.shaded.okhttp3.MediaType;
import com.aliyun.datahub.shaded.okhttp3.OkHttpClient;
import com.aliyun.datahub.shaded.okhttp3.Request;
import com.aliyun.datahub.shaded.okhttp3.RequestBody;
import com.aliyun.datahub.shaded.okhttp3.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpRequest {
    private HttpInterceptor interceptor;
    private String endpoint;
    private String path;
    private HttpMethod method;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, List<Object>> queryParams = new HashMap<String, List<Object>>();
    private OkHttpClient client;
    private HttpEntity<?> entity;
    private int maxRetryCount = 1;

    public HttpRequest(OkHttpClient client) {
        this.client = client;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public HttpRequest interceptor(HttpInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public HttpRequest endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public HttpRequest path(String path) {
        this.path = path;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public HttpRequest method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpRequest header(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpRequest queryParam(String key, Object value) {
        if (this.queryParams.containsKey(key)) {
            List<Object> values = this.queryParams.get(key);
            values.add(value);
        } else {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(value);
            this.queryParams.put(key, values);
        }
        return this;
    }

    public Map<String, List<Object>> getQueryParams() {
        return this.queryParams;
    }

    public HttpEntity<?> getEntity() {
        return this.entity;
    }

    public HttpRequest entity(HttpEntity<?> entity) {
        this.entity = entity;
        return this;
    }

    public HttpRequest maxRetryCount(int retryCount) {
        this.maxRetryCount = retryCount;
        return this;
    }

    public <T> T get(Class<T> returnType) {
        this.method(HttpMethod.GET);
        return this.fetchResponse().getEntity(returnType);
    }

    public <T> T post(Class<T> returnType) {
        this.method(HttpMethod.POST);
        return this.fetchResponse().getEntity(returnType);
    }

    public <T> T post(HttpEntity<?> entity, Class<T> returnType) {
        this.entity(entity);
        return this.post(returnType);
    }

    public <T> T put(Class<T> returnType) {
        this.method(HttpMethod.PUT);
        return this.fetchResponse().getEntity(returnType);
    }

    public <T> T put(HttpEntity<?> entity, Class<T> returnType) {
        this.entity(entity);
        return this.put(returnType);
    }

    public <T> T delete(Class<T> returnType) {
        this.method(HttpMethod.DELETE);
        return this.fetchResponse().getEntity(returnType);
    }

    public HttpResponse fetchResponse() {
        if (this.interceptor != null) {
            this.interceptor.preHandle(this);
        }
        HttpResponse response = this.executeWithRetry(this.maxRetryCount);
        if (this.interceptor != null) {
            this.interceptor.postHandle(response);
        }
        return response;
    }

    private HttpResponse executeWithRetry(int retryCount) {
        int count = 1;
        while (true) {
            try {
                return this.execute();
            }
            catch (IOException ex) {
                if (count >= retryCount) {
                    throw new RuntimeException(ex);
                }
                ++count;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private HttpResponse execute() throws IOException {
        HttpUrl httpUrl;
        String url = this.endpoint;
        if (this.path != null) {
            url = url + this.path;
        }
        if ((httpUrl = HttpUrl.parse(url)) == null) {
            throw new RuntimeException("endpoint format error. endpoint:" + this.endpoint);
        }
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder();
        for (Map.Entry<String, List<Object>> entry : this.queryParams.entrySet()) {
            for (Object o : entry.getValue()) {
                String realValue = String.valueOf(o);
                urlBuilder.addQueryParameter(entry.getKey(), realValue);
            }
        }
        Request.Builder reqBuilder = new Request.Builder().url(urlBuilder.build().toString());
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            reqBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        if (this.entity != null) {
            void var5_10;
            Object var5_7 = null;
            MediaType mediaType = MediaType.parse(this.entity.getContentType());
            if ("application/json".equalsIgnoreCase(this.entity.getContentType())) {
                String jsonStr = JsonUtils.toJson(this.entity.getEntity());
                if (jsonStr == null) {
                    throw new RuntimeException("Serialize entity to json fail");
                }
                RequestBody requestBody = RequestBody.create(mediaType, jsonStr);
            } else {
                HttpForm form = (HttpForm)this.entity.getEntity();
                String formStr = form != null ? form.toFormStr() : "";
                RequestBody requestBody = RequestBody.create(mediaType, formStr);
            }
            if (this.method == HttpMethod.PUT) {
                reqBuilder.put((RequestBody)var5_10);
            } else if (this.method == HttpMethod.POST) {
                reqBuilder.post((RequestBody)var5_10);
            }
        } else if (this.method == HttpMethod.DELETE) {
            reqBuilder.delete();
        } else if (this.method == HttpMethod.GET) {
            reqBuilder.get();
        } else if (this.method == HttpMethod.PUT) {
            reqBuilder.put(RequestBody.create(null, new byte[0]));
        }
        try (Response response = this.client.newCall(reqBuilder.build()).execute();){
            HttpResponse httpResponse = new HttpResponse(this, response, response.body().string());
            return httpResponse;
        }
    }
}

