/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example;

import com.aliyun.datahub.client.example.BaseExample;
import com.aliyun.datahub.client.model.CreateSubscriptionResult;
import com.aliyun.datahub.client.model.GetSubscriptionOffsetResult;
import com.aliyun.datahub.client.model.GetSubscriptionResult;
import com.aliyun.datahub.client.model.ListSubscriptionResult;
import com.aliyun.datahub.client.model.OpenSubscriptionSessionResult;
import com.aliyun.datahub.client.model.SubscriptionEntry;
import com.aliyun.datahub.client.model.SubscriptionOffset;
import com.aliyun.datahub.client.model.SubscriptionState;
import com.aliyun.datahub.client.model.SubscriptionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SubscriptionExample
extends BaseExample {
    @Override
    public void runExample() {
        this.operateOnSubscription();
    }

    private void operateOnSubscription() {
        CreateSubscriptionResult createSubscriptionResult = this.client.createSubscription("** datahub project **", "** datahub tuple topic **", "test subscription");
        String subId = createSubscriptionResult.getSubId();
        System.out.println("create subscription success. subId: " + subId);
        GetSubscriptionResult getSubscriptionResult = this.client.getSubscription("** datahub project **", "** datahub tuple topic **", subId);
        this.client.updateSubscription("** datahub project **", "** datahub tuple topic **", subId, "update subscription comment");
        this.client.updateSubscriptionState("** datahub project **", "** datahub tuple topic **", subId, SubscriptionState.OFFLINE);
        this.client.updateSubscriptionState("** datahub project **", "** datahub tuple topic **", subId, SubscriptionState.ONLINE);
        ArrayList<String> shardIds = new ArrayList<String>(){
            {
                this.add("0");
            }
        };
        OpenSubscriptionSessionResult openSubscriptionSessionResult = this.client.openSubscriptionSession("** datahub project **", "** datahub tuple topic **", subId, (List<String>)shardIds);
        final SubscriptionOffset subOffset = openSubscriptionSessionResult.getOffsets().get("0");
        GetSubscriptionOffsetResult getSubscriptionOffsetResult = this.client.getSubscriptionOffset("** datahub project **", "** datahub tuple topic **", subId, (List<String>)shardIds);
        HashMap<String, SubscriptionOffset> offsetMap = new HashMap<String, SubscriptionOffset>();
        offsetMap.put("0", new SubscriptionOffset(){
            {
                this.setTimestamp(100L);
                this.setSequence(1L);
                this.setSessionId(subOffset.getSessionId());
                this.setVersionId(subOffset.getVersionId());
            }
        });
        this.client.commitSubscriptionOffset("** datahub project **", "** datahub tuple topic **", subId, offsetMap);
        this.client.resetSubscriptionOffset("** datahub project **", "** datahub tuple topic **", subId, offsetMap);
        getSubscriptionOffsetResult = this.client.getSubscriptionOffset("** datahub project **", "** datahub tuple topic **", subId, (List<String>)shardIds);
        ListSubscriptionResult listSubscriptionResult = this.client.listSubscription("** datahub project **", "** datahub tuple topic **", 1, 10);
        for (SubscriptionEntry entry : listSubscriptionResult.getSubscriptions()) {
            if (entry.getType() != SubscriptionType.USER) continue;
            this.client.deleteSubscription("** datahub project **", "** datahub tuple topic **", entry.getSubId());
        }
    }
}

