/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http.interceptor.compress;

import com.aliyun.datahub.client.http.interceptor.HttpInterceptor;
import com.aliyun.datahub.client.http.interceptor.compress.RequestBodyWrapper;
import com.aliyun.datahub.shaded.okhttp3.Interceptor;
import com.aliyun.datahub.shaded.okhttp3.Request;
import com.aliyun.datahub.shaded.okhttp3.RequestBody;
import com.aliyun.datahub.shaded.okhttp3.Response;
import com.aliyun.datahub.shaded.okhttp3.ResponseBody;
import com.aliyun.datahub.shaded.okio.Buffer;
import com.aliyun.datahub.shaded.org.apache.commons.io.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class DeflateRequestInterceptor
extends HttpInterceptor {
    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(this.compressRequest(chain.request()));
        return this.decompressResponse(response);
    }

    private Request compressRequest(Request request) throws IOException {
        if (request.body() == null || request.header("Content-Encoding") != null) {
            return request;
        }
        RequestBodyWrapper wrapper = this.compressBody(request.body());
        return request.newBuilder().header("Content-Encoding", "deflate").header("Accept-Encoding", "deflate").header("x-datahub-content-raw-size", String.valueOf(wrapper.getRawSize())).method(request.method(), wrapper.getBody()).build();
    }

    private RequestBodyWrapper compressBody(RequestBody body) throws IOException {
        Buffer buffer = new Buffer();
        body.writeTo(buffer);
        long rawSize = buffer.size();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream(out);
        buffer.copyTo(dos);
        dos.close();
        return new RequestBodyWrapper(rawSize, RequestBody.create(body.contentType(), out.toByteArray()));
    }

    private Response decompressResponse(Response response) throws IOException {
        if (response.body() == null || response.header("Content-Encoding") == null) {
            return response;
        }
        return response.newBuilder().removeHeader("Content-Encoding").body(this.decompressBody(response.body())).build();
    }

    private ResponseBody decompressBody(ResponseBody body) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InflaterInputStream iis = new InflaterInputStream(body.byteStream());
        IOUtils.copy((InputStream)iis, (OutputStream)out);
        return ResponseBody.create(body.contentType(), out.toByteArray());
    }
}

