/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.util;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.type.DefaultListType;
import com.datastax.oss.driver.internal.core.type.DefaultMapType;
import com.datastax.oss.driver.internal.core.type.DefaultSetType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.cassandra.exception.CassandraConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.cassandra.exception.CassandraConnectorException;

public class TypeConvertUtil {
    public static SeaTunnelDataType<?> convert(DataType type) {
        switch (type.getProtocolCode()) {
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return BasicType.STRING_TYPE;
            }
            case 20: {
                return BasicType.BYTE_TYPE;
            }
            case 19: {
                return BasicType.SHORT_TYPE;
            }
            case 9: {
                return BasicType.INT_TYPE;
            }
            case 2: 
            case 5: {
                return BasicType.LONG_TYPE;
            }
            case 8: {
                return BasicType.FLOAT_TYPE;
            }
            case 6: 
            case 7: {
                return BasicType.DOUBLE_TYPE;
            }
            case 4: {
                return BasicType.BOOLEAN_TYPE;
            }
            case 18: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case 17: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case 11: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case 3: {
                return ArrayType.BYTE_ARRAY_TYPE;
            }
            case 33: {
                return new MapType(TypeConvertUtil.convert(((DefaultMapType)type).getKeyType()), TypeConvertUtil.convert(((DefaultMapType)type).getValueType()));
            }
            case 32: {
                return TypeConvertUtil.convertToArrayType(TypeConvertUtil.convert(((DefaultListType)type).getElementType()));
            }
            case 34: {
                return TypeConvertUtil.convertToArrayType(TypeConvertUtil.convert(((DefaultSetType)type).getElementType()));
            }
        }
        throw new CassandraConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unsupported this data type: " + type);
    }

    private static ArrayType<?, ?> convertToArrayType(SeaTunnelDataType<?> dataType) {
        if (dataType.equals((Object)BasicType.STRING_TYPE)) {
            return ArrayType.STRING_ARRAY_TYPE;
        }
        if (dataType.equals((Object)BasicType.BYTE_TYPE)) {
            return ArrayType.BYTE_ARRAY_TYPE;
        }
        if (dataType.equals((Object)BasicType.SHORT_TYPE)) {
            return ArrayType.SHORT_ARRAY_TYPE;
        }
        if (dataType.equals((Object)BasicType.INT_TYPE)) {
            return ArrayType.INT_ARRAY_TYPE;
        }
        if (dataType.equals((Object)BasicType.LONG_TYPE)) {
            return ArrayType.LONG_ARRAY_TYPE;
        }
        if (dataType.equals((Object)BasicType.FLOAT_TYPE)) {
            return ArrayType.FLOAT_ARRAY_TYPE;
        }
        if (dataType.equals((Object)BasicType.DOUBLE_TYPE)) {
            return ArrayType.DOUBLE_ARRAY_TYPE;
        }
        if (dataType.equals((Object)BasicType.BOOLEAN_TYPE)) {
            return ArrayType.BOOLEAN_ARRAY_TYPE;
        }
        throw new CassandraConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unsupported this data type: " + dataType);
    }

    public static SeaTunnelRow buildSeaTunnelRow(Row row) {
        Object[] fields = new Object[row.size()];
        ColumnDefinitions metaData = row.getColumnDefinitions();
        block21: for (int i = 0; i < row.size(); ++i) {
            switch (metaData.get(i).getType().getProtocolCode()) {
                case 1: 
                case 13: {
                    fields[i] = row.getString(i);
                    continue block21;
                }
                case 14: {
                    fields[i] = Objects.requireNonNull(row.getBigInteger(i)).toString();
                    continue block21;
                }
                case 12: 
                case 15: {
                    fields[i] = Objects.requireNonNull(row.getUuid(i)).toString();
                    continue block21;
                }
                case 16: {
                    fields[i] = Objects.requireNonNull(row.getInetAddress(i)).getHostAddress();
                    continue block21;
                }
                case 20: {
                    fields[i] = row.getByte(i);
                    continue block21;
                }
                case 19: {
                    fields[i] = row.getShort(i);
                    continue block21;
                }
                case 9: {
                    fields[i] = row.getInt(i);
                    continue block21;
                }
                case 2: {
                    fields[i] = row.getLong(i);
                    continue block21;
                }
                case 8: {
                    fields[i] = Float.valueOf(row.getFloat(i));
                    continue block21;
                }
                case 7: {
                    fields[i] = row.getDouble(i);
                    continue block21;
                }
                case 6: {
                    fields[i] = Objects.requireNonNull(row.getBigDecimal(i)).doubleValue();
                    continue block21;
                }
                case 4: {
                    fields[i] = row.getBoolean(i);
                    continue block21;
                }
                case 18: {
                    fields[i] = row.getLocalTime(i);
                    continue block21;
                }
                case 17: {
                    fields[i] = row.getLocalDate(i);
                    continue block21;
                }
                case 11: {
                    fields[i] = Timestamp.from(Objects.requireNonNull(row.getInstant(i))).toLocalDateTime();
                    continue block21;
                }
                case 3: {
                    fields[i] = ArrayUtils.toObject(Objects.requireNonNull(row.getByteBuffer(i)).array());
                    continue block21;
                }
                case 33: {
                    DataType subType = metaData.get(i).getType();
                    fields[i] = row.getMap(i, TypeConvertUtil.convert(((DefaultMapType)subType).getKeyType()).getTypeClass(), TypeConvertUtil.convert(((DefaultMapType)subType).getValueType()).getTypeClass());
                    continue block21;
                }
                case 32: {
                    Class typeClass = TypeConvertUtil.convert(((DefaultListType)metaData.get(i).getType()).getElementType()).getTypeClass();
                    if (String.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getList(i, String.class)).toArray(new String[0]);
                        continue block21;
                    }
                    if (Byte.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getList(i, Byte.class)).toArray(new Byte[0]);
                        continue block21;
                    }
                    if (Short.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getList(i, Short.class)).toArray(new Short[0]);
                        continue block21;
                    }
                    if (Integer.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getList(i, Integer.class)).toArray(new Integer[0]);
                        continue block21;
                    }
                    if (Long.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getList(i, Long.class)).toArray(new Long[0]);
                        continue block21;
                    }
                    if (Float.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getList(i, Float.class)).toArray(new Float[0]);
                        continue block21;
                    }
                    if (Double.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getList(i, Double.class)).toArray(new Double[0]);
                        continue block21;
                    }
                    if (Boolean.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getList(i, Boolean.class)).toArray(new Boolean[0]);
                        continue block21;
                    }
                    throw new CassandraConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "List unsupported this data type: " + typeClass.toString());
                }
                case 34: {
                    Class typeClass = TypeConvertUtil.convert(((DefaultSetType)metaData.get(i).getType()).getElementType()).getTypeClass();
                    if (String.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getSet(i, String.class)).toArray(new String[0]);
                        continue block21;
                    }
                    if (Byte.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getSet(i, Byte.class)).toArray(new Byte[0]);
                        continue block21;
                    }
                    if (Short.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getSet(i, Short.class)).toArray(new Short[0]);
                        continue block21;
                    }
                    if (Integer.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getSet(i, Integer.class)).toArray(new Integer[0]);
                        continue block21;
                    }
                    if (Long.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getSet(i, Long.class)).toArray(new Long[0]);
                        continue block21;
                    }
                    if (Float.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getSet(i, Float.class)).toArray(new Float[0]);
                        continue block21;
                    }
                    if (Double.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getSet(i, Double.class)).toArray(new Double[0]);
                        continue block21;
                    }
                    if (Boolean.class.equals((Object)typeClass)) {
                        fields[i] = Objects.requireNonNull(row.getSet(i, Boolean.class)).toArray(new Boolean[0]);
                        continue block21;
                    }
                    throw new CassandraConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "List unsupported this data type: " + typeClass.toString());
                }
                default: {
                    fields[i] = row.getObject(i);
                }
            }
        }
        return new SeaTunnelRow(fields);
    }

    public static BoundStatement reconvertAndInject(BoundStatement statement, int index, DataType type, Object fileValue) {
        switch (type.getProtocolCode()) {
            case 1: 
            case 13: {
                statement = (BoundStatement)statement.setString(index, (String)fileValue);
                return statement;
            }
            case 14: {
                statement = (BoundStatement)statement.setBigInteger(index, new BigInteger((String)fileValue));
                return statement;
            }
            case 12: 
            case 15: {
                statement = (BoundStatement)statement.setUuid(index, UUID.fromString((String)fileValue));
                return statement;
            }
            case 16: {
                try {
                    statement = (BoundStatement)statement.setInetAddress(index, InetAddress.getByName((String)fileValue));
                }
                catch (UnknownHostException e) {
                    throw new CassandraConnectorException((SeaTunnelErrorCode)CassandraConnectorErrorCode.PARSE_IP_ADDRESS_FAILED, e);
                }
                return statement;
            }
            case 20: {
                statement = (BoundStatement)statement.setByte(index, (byte)((Byte)fileValue));
                return statement;
            }
            case 19: {
                statement = (BoundStatement)statement.setShort(index, (short)((Short)fileValue));
                return statement;
            }
            case 9: {
                statement = (BoundStatement)statement.setInt(index, (int)((Integer)fileValue));
                return statement;
            }
            case 2: 
            case 5: {
                statement = (BoundStatement)statement.setLong(index, (long)((Long)fileValue));
                return statement;
            }
            case 8: {
                statement = (BoundStatement)statement.setFloat(index, ((Float)fileValue).floatValue());
                return statement;
            }
            case 7: {
                statement = (BoundStatement)statement.setDouble(index, (double)((Double)fileValue));
                return statement;
            }
            case 6: {
                statement = (BoundStatement)statement.setBigDecimal(index, BigDecimal.valueOf((Double)fileValue));
                return statement;
            }
            case 4: {
                statement = (BoundStatement)statement.setBoolean(index, (boolean)((Boolean)fileValue));
                return statement;
            }
            case 18: {
                statement = (BoundStatement)statement.setLocalTime(index, (LocalTime)fileValue);
                return statement;
            }
            case 17: {
                statement = (BoundStatement)statement.setLocalDate(index, (LocalDate)fileValue);
                return statement;
            }
            case 11: {
                statement = (BoundStatement)statement.setInstant(index, ((LocalDateTime)fileValue).atZone(ZoneId.systemDefault()).toInstant());
                return statement;
            }
            case 3: {
                if (fileValue.getClass().equals(Object[].class)) {
                    fileValue = Arrays.stream((Object[])fileValue).toArray(Byte[]::new);
                }
                statement = (BoundStatement)statement.setByteBuffer(index, ByteBuffer.wrap(ArrayUtils.toPrimitive((Byte[])fileValue)));
                return statement;
            }
            case 33: {
                statement = (BoundStatement)statement.set(index, (Map)fileValue, Map.class);
                return statement;
            }
            case 32: {
                statement = (BoundStatement)statement.set(index, Arrays.stream((Object[])fileValue).collect(Collectors.toList()), List.class);
                return statement;
            }
            case 34: {
                statement = (BoundStatement)statement.set(index, Arrays.stream((Object[])fileValue).collect(Collectors.toSet()), Set.class);
                return statement;
            }
        }
        statement = (BoundStatement)statement.set(index, fileValue, Object.class);
        return statement;
    }
}

