/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.connection;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ExponentialReconnectionPolicy
implements ReconnectionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ExponentialReconnectionPolicy.class);
    private final String logPrefix;
    private final long baseDelayMs;
    private final long maxDelayMs;
    private final long maxAttempts;

    public ExponentialReconnectionPolicy(DriverContext context) {
        this.logPrefix = context.getSessionName();
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        this.baseDelayMs = config.getDuration(DefaultDriverOption.RECONNECTION_BASE_DELAY).toMillis();
        this.maxDelayMs = config.getDuration(DefaultDriverOption.RECONNECTION_MAX_DELAY).toMillis();
        Preconditions.checkArgument(this.baseDelayMs > 0L, "%s must be strictly positive (got %s)", (Object)DefaultDriverOption.RECONNECTION_BASE_DELAY.getPath(), this.baseDelayMs);
        Preconditions.checkArgument(this.maxDelayMs >= 0L, "%s must be positive (got %s)", (Object)DefaultDriverOption.RECONNECTION_MAX_DELAY.getPath(), this.maxDelayMs);
        Preconditions.checkArgument(this.maxDelayMs >= this.baseDelayMs, "%s must be bigger than %s (got %s, %s)", (Object)DefaultDriverOption.RECONNECTION_MAX_DELAY.getPath(), (Object)DefaultDriverOption.RECONNECTION_BASE_DELAY.getPath(), (Object)this.maxDelayMs, (Object)this.baseDelayMs);
        int ceil = (this.baseDelayMs & this.baseDelayMs - 1L) == 0L ? 0 : 1;
        this.maxAttempts = 64L - (long)Long.numberOfLeadingZeros(Long.MAX_VALUE / this.baseDelayMs) - (long)ceil;
    }

    public long getBaseDelayMs() {
        return this.baseDelayMs;
    }

    public long getMaxDelayMs() {
        return this.maxDelayMs;
    }

    @Override
    @NonNull
    public ReconnectionPolicy.ReconnectionSchedule newNodeSchedule(@NonNull Node node) {
        LOG.debug("[{}] Creating new schedule for {}", (Object)this.logPrefix, (Object)node);
        return new ExponentialSchedule();
    }

    @Override
    @NonNull
    public ReconnectionPolicy.ReconnectionSchedule newControlConnectionSchedule(boolean isInitialConnection) {
        LOG.debug("[{}] Creating new schedule for the control connection", (Object)this.logPrefix);
        return new ExponentialSchedule();
    }

    @Override
    public void close() {
    }

    public long getMaxAttempts() {
        return this.maxAttempts;
    }

    private class ExponentialSchedule
    implements ReconnectionPolicy.ReconnectionSchedule {
        private int attempts;

        private ExponentialSchedule() {
        }

        @Override
        @NonNull
        public Duration nextDelay() {
            long delay = (long)this.attempts > ExponentialReconnectionPolicy.this.maxAttempts ? ExponentialReconnectionPolicy.this.maxDelayMs : this.calculateDelayWithJitter();
            return Duration.ofMillis(delay);
        }

        private long calculateDelayWithJitter() {
            assert ((long)this.attempts <= ExponentialReconnectionPolicy.this.maxAttempts);
            long delay = Math.min(ExponentialReconnectionPolicy.this.baseDelayMs * (1L << this.attempts++), ExponentialReconnectionPolicy.this.maxDelayMs);
            int jitter = ThreadLocalRandom.current().nextInt(85, 116);
            delay = (long)jitter * delay / 100L;
            delay = Math.min(ExponentialReconnectionPolicy.this.maxDelayMs, Math.max(ExponentialReconnectionPolicy.this.baseDelayMs, delay));
            return delay;
        }
    }
}

