/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.sink;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraParameters;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.cassandra.sink.CassandraSink;

@AutoService(value={Factory.class})
public class CassandraSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Cassandra";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{CassandraSinkOptions.HOST, CassandraSinkOptions.KEYSPACE, CassandraSinkOptions.TABLE}).bundled(new Option[]{CassandraSinkOptions.USERNAME, CassandraSinkOptions.PASSWORD}).optional(new Option[]{CassandraSinkOptions.DATACENTER, CassandraSinkOptions.CONSISTENCY_LEVEL, CassandraSinkOptions.FIELDS, CassandraSinkOptions.BATCH_SIZE, CassandraSinkOptions.BATCH_TYPE, CassandraSinkOptions.ASYNC_WRITE}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        CassandraParameters cassandraParameters = new CassandraParameters();
        cassandraParameters.buildWithConfig(context.getOptions());
        return () -> new CassandraSink(cassandraParameters, context.getCatalogTable(), context.getOptions());
    }
}

