/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.assertion.sink;

import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertFieldRule;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertRuleParser;
import org.apache.seatunnel.connectors.seatunnel.assertion.sink.AssertConfig;
import org.apache.seatunnel.connectors.seatunnel.assertion.sink.AssertSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigException;

@AutoService(value={SeaTunnelSink.class})
public class AssertSink
extends AbstractSimpleSink<SeaTunnelRow, Void> {
    private SeaTunnelRowType seaTunnelRowType;
    private List<AssertFieldRule> assertFieldRules;
    private List<AssertFieldRule.AssertRule> assertRowRules;

    public void setTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    public SeaTunnelDataType<SeaTunnelRow> getConsumedType() {
        return this.seaTunnelRowType;
    }

    @Override
    public AbstractSinkWriter<SeaTunnelRow, Void> createWriter(SinkWriter.Context context) throws IOException {
        return new AssertSinkWriter(this.seaTunnelRowType, this.assertFieldRules, this.assertRowRules);
    }

    public void prepare(Config pluginConfig) {
        if (!pluginConfig.hasPath(AssertConfig.RULES.key())) {
            Throwables.propagateIfPossible((Throwable)new ConfigException.Missing(AssertConfig.RULES.key()));
        }
        Config ruleConfig = pluginConfig.getConfig(AssertConfig.RULES.key());
        List rowConfigList = null;
        List configList = null;
        if (ruleConfig.hasPath("row_rules")) {
            rowConfigList = ruleConfig.getConfigList("row_rules");
            this.assertRowRules = new AssertRuleParser().parseRowRules(rowConfigList);
        }
        if (ruleConfig.hasPath("field_rules")) {
            configList = ruleConfig.getConfigList("field_rules");
            this.assertFieldRules = new AssertRuleParser().parseRules(configList);
        }
        if (CollectionUtils.isEmpty(configList) && CollectionUtils.isEmpty((Collection)rowConfigList)) {
            Throwables.propagateIfPossible((Throwable)new ConfigException.BadValue(AssertConfig.RULES.key(), "Assert rule config is empty, please add rule config."));
        }
    }

    public String getPluginName() {
        return "Assert";
    }
}

