/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.assertion.excecutor;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertFieldRule;

public class AssertExecutor {
    public Optional<AssertFieldRule> fail(SeaTunnelRow rowData, SeaTunnelRowType rowType, List<AssertFieldRule> assertFieldRules) {
        return assertFieldRules.stream().filter(assertFieldRule -> !this.pass(rowData, rowType, (AssertFieldRule)assertFieldRule)).findFirst();
    }

    private boolean pass(SeaTunnelRow rowData, SeaTunnelRowType rowType, AssertFieldRule assertFieldRule) {
        if (Objects.isNull(rowData)) {
            return Boolean.FALSE;
        }
        int index = Iterables.indexOf((Iterable)Lists.newArrayList((Object[])rowType.getFieldNames()), fieldName -> fieldName.equals(assertFieldRule.getFieldName()));
        Object value = rowData.getField(index);
        if (Objects.isNull(value)) {
            return Boolean.FALSE;
        }
        Boolean typeChecked = this.checkType(value, assertFieldRule.getFieldType());
        if (Boolean.FALSE.equals(typeChecked)) {
            return Boolean.FALSE;
        }
        Boolean valueChecked = this.checkValue(value, assertFieldRule.getFieldRules());
        if (Boolean.FALSE.equals(valueChecked)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkValue(Object value, List<AssertFieldRule.AssertRule> fieldValueRules) {
        Optional<AssertFieldRule.AssertRule> failValueRule = fieldValueRules.stream().filter(valueRule -> !this.pass(value, (AssertFieldRule.AssertRule)valueRule)).findFirst();
        if (failValueRule.isPresent()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean pass(Object value, AssertFieldRule.AssertRule valueRule) {
        String valueStr;
        if (AssertFieldRule.AssertRuleType.NOT_NULL.equals((Object)valueRule.getRuleType())) {
            return Objects.nonNull(value);
        }
        if (value instanceof Number && AssertFieldRule.AssertRuleType.MAX.equals((Object)valueRule.getRuleType())) {
            return ((Number)value).doubleValue() <= valueRule.getRuleValue();
        }
        if (value instanceof Number && AssertFieldRule.AssertRuleType.MIN.equals((Object)valueRule.getRuleType())) {
            return ((Number)value).doubleValue() >= valueRule.getRuleValue();
        }
        if (valueRule.getEqualTo() != null) {
            if (value instanceof String) {
                return value.equals(valueRule.getEqualTo());
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue() == Double.parseDouble(valueRule.getEqualTo());
            }
            if (value instanceof Boolean) {
                return value.equals(Boolean.parseBoolean(valueRule.getEqualTo()));
            }
            if (value instanceof LocalDateTime) {
                TemporalAccessor parsedTimestamp = DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(valueRule.getEqualTo());
                LocalTime localTime = parsedTimestamp.query(TemporalQueries.localTime());
                LocalDate localDate = parsedTimestamp.query(TemporalQueries.localDate());
                return ((LocalDateTime)value).isEqual(LocalDateTime.of(localDate, localTime));
            }
            if (value instanceof LocalDate) {
                DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                return ((LocalDate)value).isEqual(LocalDate.parse(valueRule.getEqualTo(), fmt));
            }
            if (value instanceof LocalTime) {
                DateTimeFormatter fmt = DateTimeFormatter.ofPattern("HH:mm:ss");
                return value.equals(LocalTime.parse(valueRule.getEqualTo(), fmt));
            }
            return false;
        }
        String string = valueStr = Objects.isNull(value) ? "" : String.valueOf(value);
        if (AssertFieldRule.AssertRuleType.MAX_LENGTH.equals((Object)valueRule.getRuleType())) {
            return (double)valueStr.length() <= valueRule.getRuleValue();
        }
        if (AssertFieldRule.AssertRuleType.MIN_LENGTH.equals((Object)valueRule.getRuleType())) {
            return (double)valueStr.length() >= valueRule.getRuleValue();
        }
        return Boolean.TRUE;
    }

    private Boolean checkType(Object value, SeaTunnelDataType<?> fieldType) {
        return value.getClass().equals(fieldType.getTypeClass());
    }
}

