/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.activemq.client;

import java.nio.charset.StandardCharsets;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.activemq.config.ActivemqConfig;
import org.apache.seatunnel.connectors.seatunnel.activemq.exception.ActivemqConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.activemq.exception.ActivemqConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivemqClient {
    private static final Logger log = LoggerFactory.getLogger(ActivemqClient.class);
    private final ReadonlyConfig config;
    private final ActiveMQConnectionFactory connectionFactory;
    private final Connection connection;

    public ActivemqClient(ReadonlyConfig config) {
        this.config = config;
        try {
            this.connectionFactory = this.getConnectionFactory();
            log.info("connection factory created");
            this.connection = this.createConnection(config);
            log.info("connection created");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ActivemqConnectorException((SeaTunnelErrorCode)ActivemqConnectorErrorCode.CREATE_ACTIVEMQ_CLIENT_FAILED, "Error while create AMQ client ");
        }
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        log.info("broker url : " + (String)this.config.get(ActivemqConfig.URI));
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory((String)this.config.get(ActivemqConfig.URI));
        if (this.config.get(ActivemqConfig.ALWAYS_SESSION_ASYNC) != null) {
            factory.setAlwaysSessionAsync((Boolean)this.config.get(ActivemqConfig.ALWAYS_SESSION_ASYNC));
        }
        if (this.config.get(ActivemqConfig.CLIENT_ID) != null) {
            factory.setClientID((String)this.config.get(ActivemqConfig.CLIENT_ID));
        }
        if (this.config.get(ActivemqConfig.ALWAYS_SYNC_SEND) != null) {
            factory.setAlwaysSyncSend((Boolean)this.config.get(ActivemqConfig.ALWAYS_SYNC_SEND));
        }
        if (this.config.get(ActivemqConfig.CHECK_FOR_DUPLICATE) != null) {
            factory.setCheckForDuplicates((Boolean)this.config.get(ActivemqConfig.CHECK_FOR_DUPLICATE));
        }
        if (this.config.get(ActivemqConfig.CLOSE_TIMEOUT) != null) {
            factory.setCloseTimeout((Integer)this.config.get(ActivemqConfig.CLOSE_TIMEOUT));
        }
        if (this.config.get(ActivemqConfig.CONSUMER_EXPIRY_CHECK_ENABLED) != null) {
            factory.setConsumerExpiryCheckEnabled((Boolean)this.config.get(ActivemqConfig.CONSUMER_EXPIRY_CHECK_ENABLED));
        }
        if (this.config.get(ActivemqConfig.DISPATCH_ASYNC) != null) {
            factory.setDispatchAsync((Boolean)this.config.get(ActivemqConfig.DISPATCH_ASYNC));
        }
        if (this.config.get(ActivemqConfig.WARN_ABOUT_UNSTARTED_CONNECTION_TIMEOUT) != null) {
            factory.setWarnAboutUnstartedConnectionTimeout(((Integer)this.config.get(ActivemqConfig.WARN_ABOUT_UNSTARTED_CONNECTION_TIMEOUT)).intValue());
        }
        if (this.config.get(ActivemqConfig.NESTED_MAP_AND_LIST_ENABLED) != null) {
            factory.setNestedMapAndListEnabled((Boolean)this.config.get(ActivemqConfig.NESTED_MAP_AND_LIST_ENABLED));
        }
        return factory;
    }

    public void write(byte[] msg) {
        try {
            this.connection.start();
            Session session = this.connection.createSession(false, 1);
            Queue destination = session.createQueue((String)this.config.get(ActivemqConfig.QUEUE_NAME));
            MessageProducer producer = session.createProducer(destination);
            String messageBody = new String(msg, StandardCharsets.UTF_8);
            TextMessage objectMessage = session.createTextMessage(messageBody);
            producer.send(objectMessage);
        }
        catch (JMSException e) {
            throw new ActivemqConnectorException(ActivemqConnectorErrorCode.SEND_MESSAGE_FAILED, String.format("Cannot send AMQ message %s at %s", this.config.get(ActivemqConfig.QUEUE_NAME), this.config.get(ActivemqConfig.CLIENT_ID)), e);
        }
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException e) {
            throw new ActivemqConnectorException((SeaTunnelErrorCode)ActivemqConnectorErrorCode.CLOSE_CONNECTION_FAILED, String.format("Error while closing AMQ connection with  %s", this.config.get(ActivemqConfig.QUEUE_NAME)));
        }
    }

    private Connection createConnection(ReadonlyConfig config) throws JMSException {
        if (config.get(ActivemqConfig.USERNAME) != null && config.get(ActivemqConfig.PASSWORD) != null) {
            return this.connectionFactory.createConnection((String)config.get(ActivemqConfig.USERNAME), (String)config.get(ActivemqConfig.PASSWORD));
        }
        return this.connectionFactory.createConnection();
    }

    public ActivemqClient(ReadonlyConfig config, ActiveMQConnectionFactory connectionFactory, Connection connection) {
        this.config = config;
        this.connectionFactory = connectionFactory;
        this.connection = connection;
    }
}

