/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry.custom;

import java.util.stream.Stream;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.discovery.registry.RegistryProvider;
import org.apache.seata.discovery.registry.RegistryService;
import org.apache.seata.discovery.registry.RegistryType;

@LoadLevel(name="Custom")
public class CustomRegistryProvider
implements RegistryProvider {
    private static final String FILE_CONFIG_KEY_PREFIX = "registry.custom.name";
    private final String customName;

    public CustomRegistryProvider() {
        String name = ConfigurationFactory.CURRENT_FILE_INSTANCE.getConfig(FILE_CONFIG_KEY_PREFIX);
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name value of custom registry type must not be blank");
        }
        if (Stream.of(RegistryType.values()).anyMatch(ct -> ct.name().equalsIgnoreCase(name))) {
            throw new IllegalArgumentException(String.format("custom registry type name %s is not allowed", name));
        }
        this.customName = name;
    }

    public RegistryService provide() {
        return ((RegistryProvider)EnhancedServiceLoader.load(RegistryProvider.class, (String)this.customName)).provide();
    }
}

