/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.sqlparser.druid;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import java.util.ArrayList;
import java.util.List;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.apache.seata.sqlparser.SQLRecognizerFactory;
import org.apache.seata.sqlparser.druid.DruidDbTypeAdapter;
import org.apache.seata.sqlparser.druid.SQLOperateRecognizerHolder;
import org.apache.seata.sqlparser.druid.SQLOperateRecognizerHolderFactory;

class DruidSQLRecognizerFactoryImpl
implements SQLRecognizerFactory {
    DruidSQLRecognizerFactoryImpl() {
    }

    @Override
    public List<SQLRecognizer> create(String sql, String dbType) {
        List sqlStatements;
        try {
            sqlStatements = SQLUtils.parseStatements((String)sql, (String)DruidDbTypeAdapter.getAdaptiveDbType(dbType));
        }
        catch (RuntimeException e) {
            if (this.isParserException(e)) {
                throw new NotSupportYetException("not support the sql syntax: " + sql + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml", e);
            }
            throw e;
        }
        if (CollectionUtils.isEmpty(sqlStatements)) {
            throw new UnsupportedOperationException("Unsupported SQL: " + sql);
        }
        if (sqlStatements.size() > 1 && !sqlStatements.stream().allMatch(statement -> statement instanceof SQLUpdateStatement) && !sqlStatements.stream().allMatch(statement -> statement instanceof SQLDeleteStatement)) {
            throw new UnsupportedOperationException("ONLY SUPPORT SAME TYPE (UPDATE OR DELETE) MULTI SQL -" + sql);
        }
        ArrayList<SQLRecognizer> recognizers = null;
        SQLRecognizer recognizer = null;
        for (SQLStatement sqlStatement : sqlStatements) {
            SQLOperateRecognizerHolder recognizerHolder = SQLOperateRecognizerHolderFactory.getSQLRecognizerHolder(dbType.toLowerCase());
            if (sqlStatement instanceof SQLInsertStatement) {
                recognizer = recognizerHolder.getInsertRecognizer(sql, sqlStatement);
            } else if (sqlStatement instanceof SQLUpdateStatement) {
                recognizer = recognizerHolder.getUpdateRecognizer(sql, sqlStatement);
            } else if (sqlStatement instanceof SQLDeleteStatement) {
                recognizer = recognizerHolder.getDeleteRecognizer(sql, sqlStatement);
            } else if (sqlStatement instanceof SQLSelectStatement) {
                recognizer = recognizerHolder.getSelectForUpdateRecognizer(sql, sqlStatement);
            }
            if (sqlStatement instanceof SQLReplaceStatement) {
                throw new NotSupportYetException("not support the sql syntax with ReplaceStatement:" + sqlStatement + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml");
            }
            if (recognizer == null || !recognizer.isSqlSyntaxSupports()) continue;
            if (recognizers == null) {
                recognizers = new ArrayList<SQLRecognizer>();
            }
            recognizers.add(recognizer);
        }
        return recognizers;
    }

    private boolean isParserException(Throwable e) {
        if (e == null) {
            return false;
        }
        String className = e.getClass().getName();
        return "com.alibaba.druid.sql.parser.ParserException".equals(className);
    }
}

