/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.rm.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.integration.tx.api.interceptor.ActionInterceptorHandler;
import org.apache.seata.integration.tx.api.interceptor.InvocationHandlerType;
import org.apache.seata.integration.tx.api.interceptor.InvocationWrapper;
import org.apache.seata.integration.tx.api.interceptor.SeataInterceptorPosition;
import org.apache.seata.integration.tx.api.interceptor.TwoPhaseBusinessActionParam;
import org.apache.seata.integration.tx.api.interceptor.handler.AbstractProxyInvocationHandler;
import org.apache.seata.saga.rm.api.CompensationBusinessAction;
import org.slf4j.MDC;

public class SagaAnnotationActionInterceptorHandler
extends AbstractProxyInvocationHandler {
    private Set<String> methodsToProxy;
    protected Object targetBean;
    protected ActionInterceptorHandler actionInterceptorHandler = new ActionInterceptorHandler();
    protected Map<Method, Annotation> parseAnnotationCache = new ConcurrentHashMap<Method, Annotation>();

    public SagaAnnotationActionInterceptorHandler(Object targetBean, Set<String> methodsToProxy) {
        this.targetBean = targetBean;
        this.methodsToProxy = methodsToProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doInvoke(InvocationWrapper invocation) throws Throwable {
        if (!RootContext.inGlobalTransaction() || RootContext.inSagaBranch()) {
            return invocation.proceed();
        }
        Method method = invocation.getMethod();
        Annotation businessAction = this.parseAnnotation(method);
        if (businessAction != null) {
            String xid = RootContext.getXID();
            BranchType previousBranchType = RootContext.getBranchType();
            if (this.getBranchType() != previousBranchType) {
                RootContext.bindBranchType(this.getBranchType());
            }
            try {
                TwoPhaseBusinessActionParam businessActionParam = this.createTwoPhaseBusinessActionParam(businessAction);
                Object object = this.actionInterceptorHandler.proceed(method, invocation.getArguments(), xid, businessActionParam, invocation::proceed);
                return object;
            }
            finally {
                if (this.getBranchType() != previousBranchType) {
                    RootContext.unbindBranchType();
                }
                MDC.remove((String)"X-TX-BRANCH-ID");
            }
        }
        return invocation.proceed();
    }

    @Override
    public Set<String> getMethodsToProxy() {
        return this.methodsToProxy;
    }

    @Override
    public SeataInterceptorPosition getPosition() {
        return SeataInterceptorPosition.Any;
    }

    @Override
    public String type() {
        return InvocationHandlerType.SagaAnnotation.name();
    }

    @Override
    public int order() {
        return 2;
    }

    private TwoPhaseBusinessActionParam createTwoPhaseBusinessActionParam(Annotation annotation) {
        CompensationBusinessAction businessAction = (CompensationBusinessAction)annotation;
        TwoPhaseBusinessActionParam businessActionParam = new TwoPhaseBusinessActionParam();
        businessActionParam.setActionName(businessAction.name());
        businessActionParam.setDelayReport(businessAction.isDelayReport());
        businessActionParam.setUseCommonFence(businessAction.useFence());
        businessActionParam.setBranchType(BranchType.SAGA_ANNOTATION);
        HashMap<String, Object> businessActionContextMap = new HashMap<String, Object>(4);
        businessActionContextMap.put("sys::rollback", businessAction.compensationMethod());
        businessActionContextMap.put("actionName", businessAction.name());
        businessActionContextMap.put("useTCCFence", businessAction.useFence());
        businessActionParam.setBusinessActionContext(businessActionContextMap);
        return businessActionParam;
    }

    private Annotation parseAnnotation(Method methodKey) {
        return this.parseAnnotationCache.computeIfAbsent(methodKey, method -> {
            Annotation twoPhaseBusinessAction = method.getAnnotation(this.getAnnotationClass());
            if (twoPhaseBusinessAction == null) {
                Set<Class<?>> interfaceClasses = ReflectionUtil.getInterfaces(this.targetBean.getClass());
                for (Class<?> interClass : interfaceClasses) {
                    try {
                        Method m = interClass.getMethod(method.getName(), method.getParameterTypes());
                        twoPhaseBusinessAction = m.getAnnotation(this.getAnnotationClass());
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return twoPhaseBusinessAction;
        });
    }

    private BranchType getBranchType() {
        return BranchType.SAGA_ANNOTATION;
    }

    private Class<? extends Annotation> getAnnotationClass() {
        return CompensationBusinessAction.class;
    }
}

