/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.tcc.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import java.io.IOException;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.integration.tx.api.json.JsonParser;

@LoadLevel(name="jackson")
public class JacksonJsonParser
implements JsonParser {
    private final ObjectMapper mapper = new ObjectMapper();

    public JacksonJsonParser() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.activateDefaultTyping(this.mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        this.mapper.setConfig((SerializationConfig)this.mapper.getSerializationConfig().with(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER}));
        this.mapper.setConfig((DeserializationConfig)this.mapper.getDeserializationConfig().with(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER}));
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public String toJSONString(Object object) throws IOException {
        return this.mapper.writeValueAsString(object);
    }

    @Override
    public <T> T parseObject(String text, Class<T> clazz) throws IOException {
        return (T)this.mapper.readValue(text, clazz);
    }

    @Override
    public String getName() {
        return "jackson";
    }
}

