/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo.mysql;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.common.util.UUIDGenerator;
import org.apache.seata.core.compressor.CompressorType;
import org.apache.seata.core.rpc.processor.Pair;
import org.apache.seata.rm.datasource.DataSourceProxy;
import org.apache.seata.rm.datasource.undo.AbstractUndoLogManager;
import org.apache.seata.rm.datasource.undo.UndoLogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="mysql")
public class MySQLUndoLogManager
extends AbstractUndoLogManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String INSERT_UNDO_LOG_SQL = "INSERT INTO " + UNDO_LOG_TABLE_NAME + " (" + "branch_id" + ", " + "xid" + ", " + "context" + ", " + "rollback_info" + ", " + "log_status" + ", " + "log_created" + ", " + "log_modified" + ") VALUES (?, ?, ?, ?, ?, now(6), now(6))";
    private static final String DELETE_UNDO_LOG_BY_CREATE_SQL = "DELETE FROM " + UNDO_LOG_TABLE_NAME + " WHERE " + "log_created" + " <= ? LIMIT ?";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteUndoLogByLogCreated(java.util.Date logCreated, int limitRows, Connection conn) throws SQLException {
        try (PreparedStatement deletePST = conn.prepareStatement(DELETE_UNDO_LOG_BY_CREATE_SQL);){
            deletePST.setDate(1, new Date(logCreated.getTime()));
            deletePST.setInt(2, limitRows);
            int deleteRows = deletePST.executeUpdate();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("batch delete undo log size {}", (Object)deleteRows);
            }
            int n = deleteRows;
            return n;
        }
        catch (Exception e2222) {
            if (e2222 instanceof SQLException) throw (SQLException)e2222;
            SQLException e2222 = new SQLException(e2222);
            throw (SQLException)e2222;
        }
    }

    @Override
    protected Pair<Integer, List<byte[]>> getSubRollbackInfo(Connection conn, String subIds, Long branchId, String xid) throws SQLException {
        Pair<Integer, List<byte[]>> pair;
        if (StringUtils.isBlank((String)subIds)) {
            return new Pair<Integer, List<byte[]>>(0, Collections.emptyList());
        }
        StringBuilder sqlBuilder = new StringBuilder(64);
        sqlBuilder.append("SELECT * FROM ").append(UNDO_LOG_TABLE_NAME).append(" WHERE ").append("branch_id").append(" IN ");
        String[] split = StringUtils.split((String)subIds, (String)",");
        MySQLUndoLogManager.appendInParam(split.length, sqlBuilder);
        sqlBuilder.append(" AND ").append("xid").append(" = ?");
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sqlBuilder.toString());
            int idx = 1;
            for (String subId : split) {
                ps.setLong(idx++, Long.parseLong(subId));
            }
            ps.setString(idx, xid);
            rs = ps.executeQuery();
            int total = 0;
            ArrayList<byte[]> bytesList = new ArrayList<byte[]>();
            while (rs.next()) {
                byte[] bytes = rs.getBytes("rollback_info");
                bytesList.add(bytes);
                total += bytes.length;
            }
            pair = new Pair<Integer, List<byte[]>>(total, bytesList);
        }
        catch (Exception e2) {
            try {
                SQLException e2;
                if (!(e2 instanceof SQLException)) {
                    e2 = new SQLException(e2);
                }
                throw (SQLException)e2;
            }
            catch (Throwable throwable) {
                IOUtil.close(rs, ps);
                throw throwable;
            }
        }
        IOUtil.close(rs, ps);
        return pair;
    }

    @Override
    protected String getMaxAllowedPacket(DataSourceProxy dataSourceProxy) {
        return dataSourceProxy.getVariableValue("max_allowed_packet");
    }

    @Override
    protected void insertUndoLogWithNormal(String xid, long branchId, String rollbackCtx, byte[] undoLogContent, Connection conn) throws SQLException {
        Map<String, String> decodeMap = CollectionUtils.decodeMap(rollbackCtx);
        String maxAllowedPacketStr = decodeMap.get("map");
        long maxAllowedPacket = 0x100000L;
        if (StringUtils.isNotBlank((String)maxAllowedPacketStr)) {
            maxAllowedPacket = Long.parseLong(maxAllowedPacketStr);
        }
        int limit = (int)((double)maxAllowedPacket * 0.8);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("undo log length : [{}] limit : [{}]", (Object)undoLogContent.length, (Object)limit);
        }
        if (undoLogContent.length > limit) {
            String subRollbackCtx = "branchId=" + branchId;
            int pos = 0;
            byte[] first = new byte[limit];
            StringBuilder subIdBuilder = new StringBuilder(36);
            while (pos < undoLogContent.length) {
                if (pos == 0) {
                    System.arraycopy(undoLogContent, pos, first, 0, first.length);
                    pos += first.length;
                    continue;
                }
                byte[] bytes = new byte[Math.min(undoLogContent.length - pos, limit)];
                System.arraycopy(undoLogContent, pos, bytes, 0, bytes.length);
                long subId = UUIDGenerator.generateUUID();
                subIdBuilder.append(subId).append(",");
                this.insertUndoLog(xid, subId, subRollbackCtx, bytes, AbstractUndoLogManager.State.Normal, conn);
                pos += bytes.length;
            }
            decodeMap.put("subId", subIdBuilder.toString());
            String finalRollbackCtx = CollectionUtils.encodeMap(decodeMap);
            this.insertUndoLog(xid, branchId, finalRollbackCtx, first, AbstractUndoLogManager.State.Normal, conn);
        } else {
            this.insertUndoLog(xid, branchId, rollbackCtx, undoLogContent, AbstractUndoLogManager.State.Normal, conn);
        }
    }

    @Override
    protected void insertUndoLogWithGlobalFinished(String xid, long branchId, UndoLogParser parser, Connection conn) throws SQLException {
        this.insertUndoLog(xid, branchId, this.buildContext(parser.getName(), CompressorType.NONE, new String[0]), parser.getDefaultContent(), AbstractUndoLogManager.State.GlobalFinished, conn);
    }

    private void insertUndoLog(String xid, long branchId, String rollbackCtx, byte[] undoLogContent, AbstractUndoLogManager.State state, Connection conn) throws SQLException {
        try (PreparedStatement pst = conn.prepareStatement(INSERT_UNDO_LOG_SQL);){
            pst.setLong(1, branchId);
            pst.setString(2, xid);
            pst.setString(3, rollbackCtx);
            pst.setObject(4, new ByteArrayInputStream(undoLogContent));
            pst.setInt(5, state.getValue());
            pst.executeUpdate();
        }
        catch (Exception e2) {
            SQLException e2;
            if (!(e2 instanceof SQLException)) {
                e2 = new SQLException(e2);
            }
            throw (SQLException)e2;
        }
    }
}

