/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo.dm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.core.compressor.CompressorType;
import org.apache.seata.rm.datasource.undo.AbstractUndoLogManager;
import org.apache.seata.rm.datasource.undo.UndoLogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="dm")
public class DmUndoLogManager
extends AbstractUndoLogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmUndoLogManager.class);
    protected static final String DELETE_SUB_UNDO_LOG_SQL = "DELETE FROM " + UNDO_LOG_TABLE_NAME + " WHERE \"" + "context".toUpperCase() + "\" = ? AND " + "xid" + " = ?";
    private static final String INSERT_UNDO_LOG_SQL = "INSERT INTO " + UNDO_LOG_TABLE_NAME + " (" + "branch_id" + ", " + "xid" + ", \"" + "context".toUpperCase() + "\", " + "rollback_info" + ", " + "log_status" + ", " + "log_created" + ", " + "log_modified" + ")VALUES (?, ?, ?, ?, ?, sysdate, sysdate)";
    private static final String DELETE_UNDO_LOG_BY_CREATE_SQL = "DELETE FROM " + UNDO_LOG_TABLE_NAME + " WHERE " + "log_created" + " <= ? and ROWNUM <= ?";

    @Override
    public void deleteUndoLog(String xid, long branchId, Connection conn) throws SQLException {
        try (PreparedStatement deletePST = conn.prepareStatement(DELETE_UNDO_LOG_SQL);
             PreparedStatement deleteSubPST = conn.prepareStatement(DELETE_SUB_UNDO_LOG_SQL);){
            deletePST.setLong(1, branchId);
            deletePST.setString(2, xid);
            deletePST.executeUpdate();
            deleteSubPST.setString(1, "branchId=" + branchId);
            deleteSubPST.setString(2, xid);
            deleteSubPST.executeUpdate();
        }
        catch (Exception e2) {
            SQLException e2;
            if (!(e2 instanceof SQLException)) {
                e2 = new SQLException(e2);
            }
            throw (SQLException)e2;
        }
    }

    @Override
    public void batchDeleteUndoLog(Set<String> xids, Set<Long> branchIds, Connection conn) throws SQLException {
        if (CollectionUtils.isEmpty(xids) || CollectionUtils.isEmpty(branchIds)) {
            return;
        }
        int xidSize = xids.size();
        int branchIdSize = branchIds.size();
        String batchDeleteSql = DmUndoLogManager.toBatchDeleteUndoLogSql(xidSize, branchIdSize);
        String batchDeleteSubSql = DmUndoLogManager.toBatchDeleteSubUndoLogSql(xidSize, branchIdSize);
        try (PreparedStatement deletePST = conn.prepareStatement(batchDeleteSql);
             PreparedStatement deleteSubPST = conn.prepareStatement(batchDeleteSubSql);){
            int paramsIndex = 1;
            for (Long branchId : branchIds) {
                deletePST.setLong(paramsIndex, branchId);
                deleteSubPST.setString(paramsIndex, "branchId=" + branchId);
                ++paramsIndex;
            }
            for (String xid : xids) {
                deletePST.setString(paramsIndex, xid);
                deleteSubPST.setString(paramsIndex, xid);
                ++paramsIndex;
            }
            int deleteRows = deletePST.executeUpdate();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("batch delete undo log size {}", (Object)deleteRows);
            }
            int deleteSubRows = deleteSubPST.executeUpdate();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("batch delete sub undo log size {}", (Object)deleteSubRows);
            }
        }
        catch (Exception e2) {
            SQLException e2;
            if (!(e2 instanceof SQLException)) {
                e2 = new SQLException(e2);
            }
            throw (SQLException)e2;
        }
    }

    protected static String toBatchDeleteSubUndoLogSql(int xidSize, int branchIdSize) {
        StringBuilder sqlBuilder = new StringBuilder(64);
        sqlBuilder.append("DELETE FROM ").append(UNDO_LOG_TABLE_NAME).append(" WHERE \"").append("context".toUpperCase()).append("\" IN ");
        DmUndoLogManager.appendInParam(branchIdSize, sqlBuilder);
        sqlBuilder.append(" AND ").append("xid").append(" IN ");
        DmUndoLogManager.appendInParam(xidSize, sqlBuilder);
        return sqlBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteUndoLogByLogCreated(Date logCreated, int limitRows, Connection conn) throws SQLException {
        try (PreparedStatement deletePST = conn.prepareStatement(DELETE_UNDO_LOG_BY_CREATE_SQL);){
            deletePST.setDate(1, new java.sql.Date(logCreated.getTime()));
            deletePST.setInt(2, limitRows);
            int deleteRows = deletePST.executeUpdate();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("batch delete undo log size {}", (Object)deleteRows);
            }
            int n = deleteRows;
            return n;
        }
        catch (Exception e2222) {
            if (e2222 instanceof SQLException) throw (SQLException)e2222;
            SQLException e2222 = new SQLException(e2222);
            throw (SQLException)e2222;
        }
    }

    @Override
    protected void insertUndoLogWithNormal(String xid, long branchId, String rollbackCtx, byte[] undoLogContent, Connection conn) throws SQLException {
        this.insertUndoLog(xid, branchId, rollbackCtx, undoLogContent, AbstractUndoLogManager.State.Normal, conn);
    }

    @Override
    protected void insertUndoLogWithGlobalFinished(String xid, long branchId, UndoLogParser parser, Connection conn) throws SQLException {
        this.insertUndoLog(xid, branchId, this.buildContext(parser.getName(), CompressorType.NONE, new String[0]), parser.getDefaultContent(), AbstractUndoLogManager.State.GlobalFinished, conn);
    }

    private void insertUndoLog(String xid, long branchID, String rollbackCtx, byte[] undoLogContent, AbstractUndoLogManager.State state, Connection conn) throws SQLException {
        try (PreparedStatement pst = conn.prepareStatement(INSERT_UNDO_LOG_SQL);){
            pst.setLong(1, branchID);
            pst.setString(2, xid);
            pst.setString(3, rollbackCtx);
            pst.setBytes(4, undoLogContent);
            pst.setInt(5, state.getValue());
            pst.executeUpdate();
        }
        catch (Exception e2) {
            SQLException e2;
            if (!(e2 instanceof SQLException)) {
                e2 = new SQLException(e2);
            }
            throw (SQLException)e2;
        }
    }
}

