/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.exec.dm;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.rm.datasource.StatementProxy;
import org.apache.seata.rm.datasource.exec.BaseInsertExecutor;
import org.apache.seata.rm.datasource.exec.StatementCallback;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.apache.seata.sqlparser.struct.Null;
import org.apache.seata.sqlparser.struct.Sequenceable;
import org.apache.seata.sqlparser.struct.SqlMethodExpr;
import org.apache.seata.sqlparser.struct.SqlSequenceExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="dm", scope=Scope.PROTOTYPE)
public class DmInsertExecutor
extends BaseInsertExecutor
implements Sequenceable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmInsertExecutor.class);

    public DmInsertExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    public Map<String, List<Object>> getPkValues() throws SQLException {
        Map<String, List<Object>> pkValuesMap = null;
        Boolean isContainsPk = this.containsPK();
        if (isContainsPk.booleanValue()) {
            pkValuesMap = this.getPkValuesByColumn();
        } else if (this.containsColumns()) {
            String columnName = this.getTableMeta().getPrimaryKeyOnlyName().get(0);
            pkValuesMap = Collections.singletonMap(columnName, this.getGeneratedKeys());
        } else {
            pkValuesMap = this.getPkValuesByColumn();
        }
        return pkValuesMap;
    }

    @Override
    public Map<String, List<Object>> getPkValuesByColumn() throws SQLException {
        String pkKey;
        Map<String, List<Object>> pkValuesMap = this.parsePkValuesFromStatement();
        List<Object> pkValues = pkValuesMap.get(pkKey = pkValuesMap.keySet().iterator().next());
        if (!pkValues.isEmpty() && pkValues.get(0) instanceof SqlSequenceExpr) {
            pkValuesMap.put(pkKey, this.getPkValuesBySequence((SqlSequenceExpr)pkValues.get(0)));
        } else if (pkValues.size() == 1 && pkValues.get(0) instanceof SqlMethodExpr) {
            pkValuesMap.put(pkKey, this.getGeneratedKeys());
        } else if (pkValues.size() == 1 && pkValues.get(0) instanceof Null) {
            throw new NotSupportYetException("dm not support null");
        }
        return pkValuesMap;
    }

    @Override
    public String getSequenceSql(SqlSequenceExpr expr) {
        return "SELECT " + expr.getSequence() + ".currval";
    }
}

