/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.processor.client;

import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.seata.core.protocol.AbstractResultMessage;
import org.apache.seata.core.protocol.BatchResultMessage;
import org.apache.seata.core.protocol.MergeMessage;
import org.apache.seata.core.protocol.MergeResultMessage;
import org.apache.seata.core.protocol.MergedWarpMessage;
import org.apache.seata.core.protocol.MessageFuture;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.rpc.TransactionMessageHandler;
import org.apache.seata.core.rpc.processor.RemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientOnResponseProcessor
implements RemotingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientOnResponseProcessor.class);
    private final Map<Integer, MergeMessage> mergeMsgMap;
    private final Map<Integer, Integer> childToParentMap;
    private final ConcurrentMap<Integer, MessageFuture> futures;
    private final TransactionMessageHandler transactionMessageHandler;

    public ClientOnResponseProcessor(Map<Integer, MergeMessage> mergeMsgMap, ConcurrentHashMap<Integer, MessageFuture> futures, Map<Integer, Integer> childToParentMap, TransactionMessageHandler transactionMessageHandler) {
        this.mergeMsgMap = mergeMsgMap;
        this.childToParentMap = childToParentMap;
        this.futures = futures;
        this.transactionMessageHandler = transactionMessageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(ChannelHandlerContext ctx, RpcMessage rpcMessage) throws Exception {
        if (rpcMessage.getBody() instanceof MergeResultMessage) {
            MergeResultMessage results = (MergeResultMessage)rpcMessage.getBody();
            MergedWarpMessage mergeMessage = (MergedWarpMessage)this.mergeMsgMap.remove(rpcMessage.getId());
            for (int i = 0; i < mergeMessage.msgs.size(); ++i) {
                int msgId = mergeMessage.msgIds.get(i);
                MessageFuture future = (MessageFuture)this.futures.remove(msgId);
                this.childToParentMap.remove(msgId);
                if (future == null) {
                    LOGGER.error("msg: {} is not found in futures, result message: {}", (Object)msgId, (Object)results.getMsgs()[i]);
                    continue;
                }
                future.setResultMessage(results.getMsgs()[i]);
            }
            return;
        } else if (rpcMessage.getBody() instanceof BatchResultMessage) {
            BatchResultMessage batchResultMessage = (BatchResultMessage)rpcMessage.getBody();
            for (int i = 0; i < batchResultMessage.getMsgIds().size(); ++i) {
                int msgId = batchResultMessage.getMsgIds().get(i);
                MessageFuture future = (MessageFuture)this.futures.remove(msgId);
                Integer parentId = this.childToParentMap.remove(msgId);
                if (parentId != null) {
                    this.mergeMsgMap.remove(parentId);
                }
                if (future == null) {
                    LOGGER.error("msg: {} is not found in futures, result message: {}", (Object)msgId, (Object)batchResultMessage.getResultMessages().get(i));
                    continue;
                }
                future.setResultMessage(batchResultMessage.getResultMessages().get(i));
            }
            return;
        } else {
            Integer id = rpcMessage.getId();
            try {
                MessageFuture messageFuture = (MessageFuture)this.futures.remove(id);
                if (messageFuture != null) {
                    messageFuture.setResultMessage(rpcMessage.getBody());
                    return;
                }
                if (!(rpcMessage.getBody() instanceof AbstractResultMessage) || this.transactionMessageHandler == null) return;
                this.transactionMessageHandler.onResponse((AbstractResultMessage)rpcMessage.getBody(), null);
                return;
            }
            finally {
                Integer parentId = this.childToParentMap.remove(id);
                if (parentId != null) {
                    this.mergeMsgMap.remove(parentId);
                }
            }
        }
    }
}

