/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.protocol;

import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.seata.common.Constants;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.protocol.MessageTypeAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessage
implements MessageTypeAware,
Serializable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessage.class);
    protected static final long serialVersionUID = -1441020418526899889L;
    protected static final Charset UTF8 = Constants.DEFAULT_CHARSET;
    protected ChannelHandlerContext ctx;

    public static int bytesToInt(byte[] bytes, int offset) {
        int ret = 0;
        for (int i = 0; i < 4 && i + offset < bytes.length; ++i) {
            ret <<= 8;
            ret |= bytes[i + offset] & 0xFF;
        }
        return ret;
    }

    public static void intToBytes(int i, byte[] bytes, int offset) {
        bytes[offset] = (byte)(i >> 24 & 0xFF);
        bytes[offset + 1] = (byte)(i >> 16 & 0xFF);
        bytes[offset + 2] = (byte)(i >> 8 & 0xFF);
        bytes[offset + 3] = (byte)(i & 0xFF);
    }

    public String toString() {
        return StringUtils.toString(this);
    }
}

