/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.seata.common.util.NetAddressValidatorUtil;
import org.apache.seata.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtil.class);
    public static final boolean PREFER_IPV6_ADDRESSES = Boolean.parseBoolean(System.getProperty("java.net.preferIPv6Addresses"));
    private static final String LOCALHOST = "127.0.0.1";
    private static final String ANY_HOST = "0.0.0.0";
    public static final String LOCALHOST_IPV6 = "0:0:0:0:0:0:0:1";
    public static final String LOCALHOST_SHORT_IPV6 = "::1";
    public static final String ANY_HOST_IPV6 = "0:0:0:0:0:0:0:0";
    public static final String ANY_HOST_SHORT_IPV6 = "::";
    private static volatile InetAddress LOCAL_ADDRESS = null;
    private static final Set<String> FORBIDDEN_HOSTS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("127.0.0.1", "0.0.0.0", "0:0:0:0:0:0:0:1", "::1", "0:0:0:0:0:0:0:0", "::")));

    public static String toStringAddress(SocketAddress address) {
        if (address == null) {
            return "";
        }
        return NetUtil.toStringAddress((InetSocketAddress)address);
    }

    public static String toIpAddress(SocketAddress address) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
        return inetSocketAddress.getAddress().getHostAddress();
    }

    public static String toStringAddress(InetSocketAddress address) {
        if (address.getAddress() == null) {
            return address.getHostString() + ":" + address.getPort();
        }
        return address.getAddress().getHostAddress() + ":" + address.getPort();
    }

    public static String toStringHost(InetSocketAddress address) {
        if (address.getAddress() == null) {
            return address.getHostString();
        }
        return address.getAddress().getHostAddress();
    }

    public static InetSocketAddress toInetSocketAddress(String address) {
        int port;
        String host;
        String[] ipPortStr = NetUtil.splitIPPortStr(address);
        if (null != ipPortStr) {
            host = ipPortStr[0];
            port = Integer.parseInt(ipPortStr[1]);
        } else {
            host = address;
            port = 0;
        }
        return new InetSocketAddress(host, port);
    }

    public static String[] splitIPPortStr(String address) {
        int i;
        if (StringUtils.isBlank(address)) {
            throw new IllegalArgumentException("ip and port string cannot be empty!");
        }
        if (address.charAt(0) == '[') {
            address = NetUtil.removeBrackets(address);
        }
        if ((i = address.lastIndexOf(":")) > -1) {
            String hostAddress = address.substring(0, i);
            if (hostAddress.contains("%")) {
                hostAddress = hostAddress.substring(0, hostAddress.indexOf("%"));
            }
            String portStr = address.substring(i + 1);
            if (StringUtils.isBlank(hostAddress) || StringUtils.isBlank(portStr)) {
                throw new IllegalArgumentException("Invalid endpoint format: " + address + ". Endpoint should be in the format ip:port.");
            }
            try {
                int port = Integer.parseInt(portStr);
                if (port < 1 || port > 65535) {
                    throw new IllegalArgumentException("Invalid endpoint format: " + address + ". Port must be between 1 and 65535.");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid endpoint format: " + address + ". Port must be a numeric value.", e);
            }
            return new String[]{hostAddress, portStr};
        }
        throw new IllegalArgumentException("Invalid endpoint format: " + address + ". Endpoint should be in the format ip:port.");
    }

    public static long toLong(String address) {
        InetSocketAddress ad = NetUtil.toInetSocketAddress(address);
        String[] ip = ad.getAddress().getHostAddress().split("\\.");
        long r = 0L;
        r |= Long.parseLong(ip[0]) << 40;
        r |= Long.parseLong(ip[1]) << 32;
        r |= Long.parseLong(ip[2]) << 24;
        r |= Long.parseLong(ip[3]) << 16;
        return r |= (long)ad.getPort();
    }

    public static String getLocalIp(String ... preferredNetworks) {
        InetAddress address = NetUtil.getLocalAddress(preferredNetworks);
        if (null != address) {
            String hostAddress = address.getHostAddress();
            if (address instanceof Inet6Address && hostAddress.contains("%")) {
                hostAddress = hostAddress.substring(0, hostAddress.indexOf("%"));
            }
            return hostAddress;
        }
        return NetUtil.localIP();
    }

    public static String localIP() {
        if (PREFER_IPV6_ADDRESSES) {
            return LOCALHOST_IPV6;
        }
        return LOCALHOST;
    }

    public static String getLocalHost() {
        InetAddress address = NetUtil.getLocalAddress(new String[0]);
        return address == null ? "localhost" : address.getHostName();
    }

    public static InetAddress getLocalAddress(String ... preferredNetworks) {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetUtil.getLocalAddress0(preferredNetworks);
        return localAddress;
    }

    private static InetAddress getLocalAddress0(String ... preferredNetworks) {
        InetAddress localAddress;
        block13: {
            localAddress = null;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces == null) break block13;
                while (interfaces.hasMoreElements()) {
                    try {
                        NetworkInterface network = interfaces.nextElement();
                        if (!network.isUp()) continue;
                        Enumeration<InetAddress> addresses = network.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress address = addresses.nextElement();
                                if (!NetUtil.isValidAddress(address)) continue;
                                if (null == localAddress) {
                                    localAddress = address;
                                }
                                if (preferredNetworks.length > 0) {
                                    String ip = address.getHostAddress();
                                    for (String regex : preferredNetworks) {
                                        if (StringUtils.isBlank(regex) || !ip.matches(regex) && !ip.startsWith(regex)) continue;
                                        return address;
                                    }
                                    continue;
                                }
                                return address;
                            }
                            catch (Throwable e) {
                                LOGGER.warn("Failed to retrieving ip address, {}", (Object)e.getMessage(), (Object)e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Failed to retrieving ip address, {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to retrieving ip address, {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (localAddress == null) {
            LOGGER.error("Could not get local host ip address, will use 127.0.0.1 instead.");
        } else {
            LOGGER.error("Could not match ip by preferredNetworks:{}, will use default first ip {} instead.", (Object)Arrays.toString(preferredNetworks), (Object)localAddress.getHostAddress());
        }
        return localAddress;
    }

    public static void validAddress(InetSocketAddress address) {
        if (address.getHostName() == null || 0 == address.getPort()) {
            throw new IllegalArgumentException("invalid address:" + address);
        }
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String hostAddress = address.getHostAddress();
        if (address instanceof Inet6Address) {
            if (!PREFER_IPV6_ADDRESSES) {
                return false;
            }
            if (address.isAnyLocalAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress() || NetUtil.isUniqueLocalAddress(address)) {
                return false;
            }
            return NetUtil.isValidIPv6(hostAddress);
        }
        return !FORBIDDEN_HOSTS.contains(hostAddress) && NetUtil.isValidIPv4(hostAddress);
    }

    public static boolean isValidIp(String ip, boolean validLocalAndAny) {
        if (ip == null) {
            return false;
        }
        ip = NetUtil.convertIpIfNecessary(ip);
        if (validLocalAndAny) {
            return NetUtil.isValidIPv4(ip) || NetUtil.isValidIPv6(ip);
        }
        return !FORBIDDEN_HOSTS.contains(ip) && (NetUtil.isValidIPv4(ip) || NetUtil.isValidIPv6(ip));
    }

    private static String convertIpIfNecessary(String ip) {
        if (NetUtil.isValidIPv4(ip) || NetUtil.isValidIPv6(ip)) {
            return ip;
        }
        try {
            return InetAddress.getByName(ip).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isValidIPv4(String ip) {
        return NetAddressValidatorUtil.isIPv4Address(ip);
    }

    public static boolean isValidIPv6(String ip) {
        return NetAddressValidatorUtil.isIPv6Address(ip);
    }

    private static boolean isUniqueLocalAddress(InetAddress address) {
        byte[] ip = address.getAddress();
        return (ip[0] & 0xFF) == 253;
    }

    private static String removeBrackets(String str) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        return str.replaceAll("[\\[\\]]", "");
    }

    public static List<String> getHostByName(String ipOrDomain) {
        if (ipOrDomain == null) {
            return null;
        }
        ArrayList<String> ipAddressList = new ArrayList<String>();
        if (NetUtil.isValidIPv4(ipOrDomain) || NetUtil.isValidIPv6(ipOrDomain)) {
            ipAddressList.add(ipOrDomain);
            return ipAddressList;
        }
        try {
            InetAddress[] allByName;
            for (InetAddress address : allByName = InetAddress.getAllByName(ipOrDomain)) {
                ipAddressList.add(address.getHostAddress());
            }
            return ipAddressList;
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Failed to resolve ip address, {}", (Object)e.getMessage());
            ipAddressList.add(ipOrDomain);
            return ipAddressList;
        }
    }
}

