/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.seata;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.common.util.BufferUtils;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.serializer.seata.MessageCodecFactory;
import org.apache.seata.serializer.seata.MessageSeataCodec;

@LoadLevel(name="SEATA", scope=Scope.PROTOTYPE)
public class SeataSerializer
implements Serializer {
    Serializer versionSeataSerializer;

    public SeataSerializer(Byte version) {
        if (version == 0) {
            this.versionSeataSerializer = SeataSerializerV0.getInstance();
        } else if (version == 1) {
            this.versionSeataSerializer = SeataSerializerV1.getInstance();
        }
        if (this.versionSeataSerializer == null) {
            throw new UnsupportedOperationException("version is not supported");
        }
    }

    @Override
    public <T> byte[] serialize(T t) {
        return this.versionSeataSerializer.serialize(t);
    }

    @Override
    public <T> T deserialize(byte[] bytes) {
        return this.versionSeataSerializer.deserialize(bytes);
    }

    private static <T> T deserializeByVersion(byte[] bytes, byte version) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("Nothing to decode.");
        }
        if (bytes.length < 2) {
            throw new IllegalArgumentException("The byte[] isn't available for decode.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        short typecode = byteBuffer.getShort();
        ByteBuffer in = byteBuffer.slice();
        AbstractMessage abstractMessage = MessageCodecFactory.getMessage(typecode);
        MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typecode, version);
        messageCodec.decode(abstractMessage, in);
        return (T)abstractMessage;
    }

    static class SeataSerializerV0
    implements Serializer {
        private static volatile SeataSerializerV0 instance;

        private SeataSerializerV0() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static SeataSerializerV0 getInstance() {
            if (instance != null) return instance;
            Class<SeataSerializerV0> clazz = SeataSerializerV0.class;
            synchronized (SeataSerializerV0.class) {
                if (instance != null) return instance;
                instance = new SeataSerializerV0();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public <T> byte[] serialize(T t) {
            if (!(t instanceof AbstractMessage)) {
                throw new IllegalArgumentException("AbstractMessage isn't available.");
            }
            AbstractMessage abstractMessage = (AbstractMessage)t;
            short typecode = abstractMessage.getTypeCode();
            MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typecode, (byte)0);
            ByteBuf out = Unpooled.buffer((int)1024);
            messageCodec.encode(t, out);
            byte[] body = new byte[out.readableBytes()];
            out.readBytes(body);
            ByteBuffer byteBuffer = ByteBuffer.allocate(body.length);
            byteBuffer.put(body);
            BufferUtils.flip(byteBuffer);
            byte[] content = new byte[byteBuffer.limit()];
            byteBuffer.get(content);
            return content;
        }

        @Override
        public <T> T deserialize(byte[] bytes) {
            return (T)SeataSerializer.deserializeByVersion(bytes, (byte)0);
        }
    }

    static class SeataSerializerV1
    implements Serializer {
        private static volatile SeataSerializerV1 instance;

        private SeataSerializerV1() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static SeataSerializerV1 getInstance() {
            if (instance != null) return instance;
            Class<SeataSerializerV1> clazz = SeataSerializerV1.class;
            synchronized (SeataSerializerV1.class) {
                if (instance != null) return instance;
                instance = new SeataSerializerV1();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public <T> byte[] serialize(T t) {
            if (!(t instanceof AbstractMessage)) {
                throw new IllegalArgumentException("AbstractMessage isn't available.");
            }
            AbstractMessage abstractMessage = (AbstractMessage)t;
            short typecode = abstractMessage.getTypeCode();
            MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typecode, (byte)1);
            ByteBuf out = Unpooled.buffer((int)1024);
            messageCodec.encode(t, out);
            byte[] body = new byte[out.readableBytes()];
            out.readBytes(body);
            ByteBuffer byteBuffer = ByteBuffer.allocate(2 + body.length);
            byteBuffer.putShort(typecode);
            byteBuffer.put(body);
            BufferUtils.flip(byteBuffer);
            byte[] content = new byte[byteBuffer.limit()];
            byteBuffer.get(content);
            return content;
        }

        @Override
        public <T> T deserialize(byte[] bytes) {
            return (T)SeataSerializer.deserializeByVersion(bytes, (byte)1);
        }
    }
}

