/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo.sqlserver;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.rm.datasource.SqlGenerateUtils;
import org.apache.seata.rm.datasource.sql.struct.Field;
import org.apache.seata.rm.datasource.sql.struct.Row;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.rm.datasource.undo.SQLUndoLog;
import org.apache.seata.rm.datasource.undo.sqlserver.BaseSqlServerUndoExecutor;
import org.apache.seata.sqlparser.util.ColumnUtils;

public class SqlServerUndoUpdateExecutor
extends BaseSqlServerUndoExecutor {
    public SqlServerUndoUpdateExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected String buildUndoSQL() {
        TableRecords beforeImage = this.sqlUndoLog.getBeforeImage();
        List<Row> beforeImageRows = beforeImage.getRows();
        if (CollectionUtils.isEmpty(beforeImageRows)) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        Row row = beforeImageRows.get(0);
        List<Field> nonPkFields = row.nonPrimaryKeys();
        String updateColumns = nonPkFields.stream().map(field -> ColumnUtils.addEscape(field.getName(), "sqlserver") + " = ?").collect(Collectors.joining(", "));
        List<String> pkNameList = this.getOrderedPkList(beforeImage, row, "sqlserver").stream().map(Field::getName).collect(Collectors.toList());
        String whereSql = SqlGenerateUtils.buildWhereConditionByPKs(pkNameList, "sqlserver");
        return "UPDATE " + this.sqlUndoLog.getTableName() + " SET " + updateColumns + " WHERE " + whereSql;
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getBeforeImage();
    }
}

