/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.fence.store.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.seata.common.exception.DataAccessException;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.integration.tx.api.fence.exception.CommonFenceException;
import org.apache.seata.integration.tx.api.fence.store.CommonFenceDO;
import org.apache.seata.integration.tx.api.fence.store.CommonFenceStore;
import org.apache.seata.integration.tx.api.fence.store.db.sql.CommonFenceStoreSqls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonFenceStoreDataBaseDAO
implements CommonFenceStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonFenceStoreDataBaseDAO.class);
    private String logTableName = "tcc_fence_log";
    private static volatile CommonFenceStoreDataBaseDAO instance = null;

    private CommonFenceStoreDataBaseDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommonFenceStore getInstance() {
        if (instance != null) return instance;
        Class<CommonFenceStore> clazz = CommonFenceStore.class;
        synchronized (CommonFenceStore.class) {
            if (instance != null) return instance;
            instance = new CommonFenceStoreDataBaseDAO();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public CommonFenceDO queryCommonFenceDO(Connection conn, String xid, Long branchId) {
        CommonFenceDO commonFenceDO;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            ps = null;
            rs = null;
            String sql = CommonFenceStoreSqls.getQuerySQLByBranchIdAndXid(this.logTableName);
            ps = conn.prepareStatement(sql);
            ps.setString(1, xid);
            ps.setLong(2, branchId);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            CommonFenceDO commonFenceDO2 = new CommonFenceDO();
            commonFenceDO2.setXid(rs.getString("xid"));
            commonFenceDO2.setBranchId(rs.getLong("branch_id"));
            commonFenceDO2.setStatus(rs.getInt("status"));
            CommonFenceDO commonFenceDO3 = commonFenceDO2;
            IOUtil.close(rs, ps);
            return commonFenceDO3;
        }
        try {
            commonFenceDO = null;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(rs, ps);
                throw throwable;
            }
        }
        IOUtil.close(rs, ps);
        return commonFenceDO;
    }

    @Override
    public Set<String> queryEndStatusXidsByDate(Connection conn, Date datetime, int limit) {
        HashSet<String> hashSet;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = CommonFenceStoreSqls.getQueryEndStatusSQLByDate(this.logTableName, CommonFenceStoreDataBaseDAO.isOracle(conn));
            ps = conn.prepareStatement(sql);
            ps.setTimestamp(1, new Timestamp(datetime.getTime()));
            ps.setInt(2, limit);
            rs = ps.executeQuery();
            HashSet<String> xids = new HashSet<String>(limit);
            while (rs.next()) {
                xids.add(rs.getString("xid"));
            }
            hashSet = xids;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(rs, ps);
                throw throwable;
            }
        }
        IOUtil.close(rs, ps);
        return hashSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean insertCommonFenceDO(Connection conn, CommonFenceDO commonFenceDO) {
        boolean bl;
        PreparedStatement ps = null;
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String sql = CommonFenceStoreSqls.getInsertLocalTCCLogSQL(this.logTableName);
            ps = conn.prepareStatement(sql);
            ps.setString(1, commonFenceDO.getXid());
            ps.setLong(2, commonFenceDO.getBranchId());
            ps.setString(3, commonFenceDO.getActionName());
            ps.setInt(4, commonFenceDO.getStatus());
            ps.setTimestamp(5, now);
            ps.setTimestamp(6, now);
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new CommonFenceException(String.format("Insert tcc fence record duplicate key exception. xid= %s, branchId= %s", commonFenceDO.getXid(), commonFenceDO.getBranchId()), FrameworkErrorCode.DuplicateKeyException);
                catch (SQLException e2) {
                    throw new StoreException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(ps);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)ps);
        return bl;
    }

    @Override
    public boolean updateCommonFenceDO(Connection conn, String xid, Long branchId, int newStatus, int oldStatus) {
        boolean bl;
        PreparedStatement ps = null;
        try {
            String sql = CommonFenceStoreSqls.getUpdateStatusSQLByBranchIdAndXid(this.logTableName);
            ps = conn.prepareStatement(sql);
            ps.setInt(1, newStatus);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setString(3, xid);
            ps.setLong(4, branchId);
            ps.setInt(5, oldStatus);
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(ps);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)ps);
        return bl;
    }

    @Override
    public boolean deleteCommonFenceDO(Connection conn, String xid, Long branchId) {
        boolean bl;
        PreparedStatement ps = null;
        try {
            String sql = CommonFenceStoreSqls.getDeleteSQLByBranchIdAndXid(this.logTableName);
            ps = conn.prepareStatement(sql);
            ps.setString(1, xid);
            ps.setLong(2, branchId);
            ps.executeUpdate();
            bl = true;
        }
        catch (SQLException e) {
            try {
                throw new StoreException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(ps);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)ps);
        return bl;
    }

    @Override
    public int deleteTCCFenceDO(Connection conn, List<String> xids) {
        int n;
        PreparedStatement ps = null;
        try {
            String paramsPlaceHolder = StringUtils.repeat((String)"?", (String)",", (int)xids.size());
            String sql = CommonFenceStoreSqls.getDeleteSQLByXids(this.logTableName, paramsPlaceHolder);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < xids.size(); ++i) {
                ps.setString(i + 1, xids.get(i));
            }
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(ps);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)ps);
        return n;
    }

    @Override
    public void setLogTableName(String logTableName) {
        this.logTableName = logTableName;
    }

    private static boolean isOracle(Connection connection) {
        try {
            String url = connection.getMetaData().getURL();
            return url.toLowerCase().contains(":oracle:");
        }
        catch (SQLException e) {
            LOGGER.error("get db type fail", (Throwable)e);
            return false;
        }
    }
}

