/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry.sofa;

import com.alipay.sofa.registry.client.api.RegistryClient;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.SubscriberDataObserver;
import com.alipay.sofa.registry.client.api.model.RegistryType;
import com.alipay.sofa.registry.client.api.registration.PublisherRegistration;
import com.alipay.sofa.registry.client.api.registration.SubscriberRegistration;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClient;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClientConfig;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClientConfigBuilder;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.exception.ConfigNotFoundException;
import org.apache.seata.discovery.registry.RegistryService;

public class SofaRegistryServiceImpl
implements RegistryService<SubscriberDataObserver> {
    private static final String SOFA_FILEKEY_PREFIX = "registry.sofa.";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String PRO_REGION_KEY = "region";
    private static final String PRO_DATACENTER_KEY = "datacenter";
    private static final String PRO_GROUP_KEY = "group";
    private static final String PRO_APPLICATION_KEY = "application";
    private static final String PRO_CLUSTER_KEY = "cluster";
    private static final String PRO_ADDRESS_WAIT_TIME_KEY = "addressWaitTime";
    private static final String DEFAULT_LOCAL_DATACENTER = "DefaultDataCenter";
    private static final String DEFAULT_LOCAL_REGION = "DEFAULT_ZONE";
    private static final String DEFAULT_GROUP = "SEATA_GROUP";
    private static final String DEFAULT_APPLICATION = "default";
    private static final String DEFAULT_CLUSTER = "default";
    private static final String DEFAULT_ADDRESS_WAIT_TIME = "3000";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static final String HOST_SEPERATOR = ":";
    private static final String REGISTRY_TYPE = "sofa";
    private static final ConcurrentMap<String, List<SubscriberDataObserver>> LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, List<SubscriberDataObserver>>();
    private static final ConcurrentMap<String, List<InetSocketAddress>> CLUSTER_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();
    private static Properties registryProps;
    private static volatile RegistryClient registryClient;
    private static volatile SofaRegistryServiceImpl instance;
    private String transactionServiceGroup;

    private SofaRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static SofaRegistryServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<SofaRegistryServiceImpl> clazz = SofaRegistryServiceImpl.class;
        synchronized (SofaRegistryServiceImpl.class) {
            if (instance != null) return instance;
            registryProps = SofaRegistryServiceImpl.getNamingProperties();
            instance = new SofaRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress(address);
        String clusterName = registryProps.getProperty(PRO_CLUSTER_KEY);
        PublisherRegistration publisherRegistration = new PublisherRegistration(clusterName);
        publisherRegistration.setGroup(registryProps.getProperty(PRO_GROUP_KEY));
        String serviceData = address.getAddress().getHostAddress() + HOST_SEPERATOR + address.getPort();
        this.getRegistryInstance().register(publisherRegistration, new String[]{serviceData});
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
        NetUtil.validAddress(address);
        String clusterName = registryProps.getProperty(PRO_CLUSTER_KEY);
        this.getRegistryInstance().unregister(clusterName, registryProps.getProperty(PRO_GROUP_KEY), RegistryType.PUBLISHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RegistryClient getRegistryInstance() {
        if (registryClient != null) return registryClient;
        Class<SofaRegistryServiceImpl> clazz = SofaRegistryServiceImpl.class;
        synchronized (SofaRegistryServiceImpl.class) {
            if (registryClient != null) return registryClient;
            String address = registryProps.getProperty(PRO_SERVER_ADDR_KEY);
            String portStr = StringUtils.substringAfter((String)address, (String)HOST_SEPERATOR);
            DefaultRegistryClientConfig config = DefaultRegistryClientConfigBuilder.start().setAppName(this.getApplicationName()).setDataCenter(registryProps.getProperty(PRO_DATACENTER_KEY)).setZone(registryProps.getProperty(PRO_REGION_KEY)).setRegistryEndpoint(StringUtils.substringBefore((String)address, (String)HOST_SEPERATOR)).setRegistryEndpointPort(Integer.parseInt(portStr)).build();
            DefaultRegistryClient result = new DefaultRegistryClient((RegistryClientConfig)config);
            result.init();
            registryClient = result;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return registryClient;
        }
    }

    @Override
    public void subscribe(String cluster, SubscriberDataObserver listener) throws Exception {
        SubscriberRegistration subscriberRegistration = new SubscriberRegistration(cluster, listener);
        subscriberRegistration.setScopeEnum(ScopeEnum.global);
        subscriberRegistration.setGroup(registryProps.getProperty(PRO_GROUP_KEY));
        LISTENER_SERVICE_MAP.computeIfAbsent(cluster, key -> new ArrayList()).add(listener);
        this.getRegistryInstance().register(subscriberRegistration);
    }

    @Override
    public void unsubscribe(String cluster, SubscriberDataObserver listener) throws Exception {
        this.getRegistryInstance().unregister(cluster, registryProps.getProperty(PRO_GROUP_KEY), RegistryType.SUBSCRIBER);
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        this.transactionServiceGroup = key;
        String clusterName = this.getServiceGroup(key);
        if (clusterName == null) {
            String missingDataId = "service.vgroupMapping." + key;
            throw new ConfigNotFoundException("%s configuration item is required", missingDataId);
        }
        if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
            CountDownLatch respondRegistries = new CountDownLatch(1);
            this.subscribe(clusterName, (dataId, data) -> {
                Map instances = data.getZoneData();
                if (instances == null && CLUSTER_ADDRESS_MAP.get(clusterName) != null) {
                    CLUSTER_ADDRESS_MAP.remove(clusterName);
                } else {
                    List<InetSocketAddress> newAddressList = this.flatData(instances);
                    CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
                    this.removeOfflineAddressesIfNecessary(this.transactionServiceGroup, clusterName, newAddressList);
                }
                respondRegistries.countDown();
            });
            String property = registryProps.getProperty(PRO_ADDRESS_WAIT_TIME_KEY);
            respondRegistries.await(Integer.parseInt(property), TimeUnit.MILLISECONDS);
        }
        return (List)CLUSTER_ADDRESS_MAP.get(clusterName);
    }

    private List<InetSocketAddress> flatData(Map<String, List<String>> instances) {
        ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>();
        for (Map.Entry<String, List<String>> entry : instances.entrySet()) {
            for (String str : entry.getValue()) {
                String ip = StringUtils.substringBeforeLast((String)str, (String)HOST_SEPERATOR);
                String port = StringUtils.substringAfterLast((String)str, (String)HOST_SEPERATOR);
                InetSocketAddress inetSocketAddress = new InetSocketAddress(ip, Integer.parseInt(port));
                result.add(inetSocketAddress);
            }
        }
        return result;
    }

    @Override
    public void close() throws Exception {
    }

    private static Properties getNamingProperties() {
        String group;
        Properties properties = new Properties();
        if (System.getProperty("registry.sofa.serverAddr") != null) {
            properties.setProperty(PRO_SERVER_ADDR_KEY, System.getProperty("registry.sofa.serverAddr"));
        } else {
            String address = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaAddrFileKey());
            if (address != null) {
                properties.setProperty(PRO_SERVER_ADDR_KEY, address);
            }
        }
        if (System.getProperty("registry.sofa.region") != null) {
            properties.setProperty(PRO_REGION_KEY, System.getProperty("registry.sofa.region"));
        } else {
            String region = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaRegionFileKey());
            if (region == null) {
                region = DEFAULT_LOCAL_REGION;
            }
            properties.setProperty(PRO_REGION_KEY, region);
        }
        if (System.getProperty("registry.sofa.datacenter") != null) {
            properties.setProperty(PRO_DATACENTER_KEY, System.getProperty("registry.sofa.datacenter"));
        } else {
            String datacenter = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaDataCenterFileKey());
            if (datacenter == null) {
                datacenter = DEFAULT_LOCAL_DATACENTER;
            }
            properties.setProperty(PRO_DATACENTER_KEY, datacenter);
        }
        if (System.getProperty("registry.sofa.group") != null) {
            properties.setProperty(PRO_GROUP_KEY, System.getProperty("registry.sofa.group"));
        } else {
            group = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaGroupFileKey());
            if (group == null) {
                group = DEFAULT_GROUP;
            }
            properties.setProperty(PRO_GROUP_KEY, group);
        }
        if (System.getProperty("registry.sofa.cluster") != null) {
            properties.setProperty(PRO_CLUSTER_KEY, System.getProperty("registry.sofa.cluster"));
        } else {
            String cluster = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaClusterFileKey());
            if (cluster == null) {
                cluster = "default";
            }
            properties.setProperty(PRO_CLUSTER_KEY, cluster);
        }
        if (System.getProperty("registry.sofa.addressWaitTime") != null) {
            properties.setProperty(PRO_ADDRESS_WAIT_TIME_KEY, System.getProperty("registry.sofa.addressWaitTime"));
        } else {
            group = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaAddressWaitTimeFileKey());
            if (group == null) {
                group = DEFAULT_ADDRESS_WAIT_TIME;
            }
            properties.setProperty(PRO_ADDRESS_WAIT_TIME_KEY, group);
        }
        return properties;
    }

    private static String getSofaClusterFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_CLUSTER_KEY);
    }

    private static String getSofaAddressWaitTimeFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_ADDRESS_WAIT_TIME_KEY);
    }

    private static String getSofaAddrFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_SERVER_ADDR_KEY);
    }

    private static String getSofaRegionFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_REGION_KEY);
    }

    private static String getSofaDataCenterFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_DATACENTER_KEY);
    }

    private static String getSofaGroupFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_GROUP_KEY);
    }

    private String getApplicationFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_APPLICATION_KEY);
    }

    private String getApplicationName() {
        String application = FILE_CONFIG.getConfig(this.getApplicationFileKey());
        if (application == null) {
            application = "default";
        }
        return application;
    }
}

