/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.serializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.EnhancedServiceNotFoundException;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.core.serializer.SerializerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializerServiceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerServiceLoader.class);
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final SerializerType[] DEFAULT_SERIALIZER_TYPE = new SerializerType[]{SerializerType.SEATA, SerializerType.PROTOBUF, SerializerType.KRYO, SerializerType.HESSIAN, SerializerType.FASTJSON2, SerializerType.FURY};
    private static final Map<String, Serializer> SERIALIZER_MAP = new HashMap<String, Serializer>();
    private static final String SPLIT_CHAR = ",";
    private static final String PROTOBUF_SERIALIZER_CLASS_NAME = "org.apache.seata.serializer.protobuf.ProtobufSerializer";
    private static final boolean CONTAINS_PROTOBUF_DEPENDENCY = ReflectionUtil.isClassPresent("org.apache.seata.serializer.protobuf.ProtobufSerializer");

    private SerializerServiceLoader() {
    }

    public static Serializer load(SerializerType type, byte version) throws EnhancedServiceNotFoundException {
        if (type == SerializerType.PROTOBUF && !CONTAINS_PROTOBUF_DEPENDENCY) {
            throw new EnhancedServiceNotFoundException("The class 'org.apache.seata.serializer.protobuf.ProtobufSerializer' not found. Please manually reference 'org.apache.seata:seata-serializer-protobuf' dependency.");
        }
        String key = SerializerServiceLoader.serializerKey(type, version);
        Serializer serializer = SERIALIZER_MAP.get(key);
        if (serializer == null) {
            serializer = type == SerializerType.SEATA ? EnhancedServiceLoader.load(Serializer.class, type.name(), new Object[]{version}) : EnhancedServiceLoader.load(Serializer.class, type.name());
            SERIALIZER_MAP.put(key, serializer);
        }
        return serializer;
    }

    public static Serializer load(SerializerType type) throws EnhancedServiceNotFoundException {
        if (type == SerializerType.PROTOBUF && !CONTAINS_PROTOBUF_DEPENDENCY) {
            throw new EnhancedServiceNotFoundException("The class 'org.apache.seata.serializer.protobuf.ProtobufSerializer' not found. Please manually reference 'org.apache.seata:seata-serializer-protobuf' dependency.");
        }
        String key = type.name();
        Serializer serializer = SERIALIZER_MAP.get(key);
        if (serializer == null) {
            serializer = EnhancedServiceLoader.load(Serializer.class, type.name());
            SERIALIZER_MAP.put(key, serializer);
        }
        return serializer;
    }

    private static String serializerKey(SerializerType type, byte version) {
        if (type == SerializerType.SEATA) {
            return type.name() + version;
        }
        return type.name();
    }

    public static List<SerializerType> getSupportedSerializers() {
        String[] serializerNameArray;
        ArrayList<SerializerType> supportedSerializers = new ArrayList<SerializerType>();
        String defaultSupportSerializers = Arrays.stream(DEFAULT_SERIALIZER_TYPE).map(Enum::name).collect(Collectors.joining(SPLIT_CHAR));
        String serializerNames = CONFIG.getConfig("transport.serialization", defaultSupportSerializers);
        for (String serializerName : serializerNameArray = serializerNames.split(SPLIT_CHAR)) {
            try {
                SerializerType serializerType = SerializerType.getByName(serializerName);
                supportedSerializers.add(serializerType);
            }
            catch (IllegalArgumentException ignore) {
                LOGGER.warn("Invalid serializer name: " + serializerName);
            }
        }
        return supportedSerializers.stream().distinct().collect(Collectors.toList());
    }

    public static SerializerType getDefaultSerializerType() {
        return SerializerServiceLoader.getSupportedSerializers().get(0);
    }
}

