/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext.routers;

import java.util.Stack;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.pcext.StateInstruction;
import org.apache.seata.saga.engine.pcext.StateRouter;
import org.apache.seata.saga.engine.pcext.utils.CompensationHolder;
import org.apache.seata.saga.engine.pcext.utils.EngineUtils;
import org.apache.seata.saga.engine.pcext.utils.LoopTaskUtils;
import org.apache.seata.saga.proctrl.HierarchicalProcessContext;
import org.apache.seata.saga.proctrl.Instruction;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.statelang.domain.CompensateSubStateMachineState;
import org.apache.seata.saga.statelang.domain.ExecutionStatus;
import org.apache.seata.saga.statelang.domain.State;
import org.apache.seata.saga.statelang.domain.StateInstance;
import org.apache.seata.saga.statelang.domain.StateMachine;
import org.apache.seata.saga.statelang.domain.SubStateMachine;
import org.apache.seata.saga.statelang.domain.impl.AbstractTaskState;
import org.apache.seata.saga.statelang.domain.impl.LoopStartStateImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStateRouter
implements StateRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStateRouter.class);

    @Override
    public Instruction route(ProcessContext context, State state) throws EngineExecutionException {
        StateInstruction stateInstruction = context.getInstruction(StateInstruction.class);
        if (stateInstruction.isEnd()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("StateInstruction is ended, Stop the StateMachine executing. StateMachine[{}] Current State[{}]", (Object)stateInstruction.getStateMachineName(), (Object)state.getName());
            }
            return null;
        }
        if (Boolean.TRUE.equals(context.getVariable("_is_loop_state_"))) {
            return null;
        }
        State compensationTriggerState = (State)context.getVariable("_is_compensating_");
        if (compensationTriggerState != null) {
            return this.compensateRoute(context, compensationTriggerState);
        }
        String next = (String)context.getVariable("_current_exception_route_");
        if (StringUtils.hasLength(next)) {
            context.removeVariable("_current_exception_route_");
        } else {
            next = state.getNext();
        }
        if (!StringUtils.hasLength(next) && context.hasVariable("_current_choice_")) {
            next = (String)context.getVariable("_current_choice_");
            context.removeVariable("_current_choice_");
        }
        if (!StringUtils.hasLength(next)) {
            return null;
        }
        StateMachine stateMachine = state.getStateMachine();
        State nextState = stateMachine.getState(next);
        if (nextState == null) {
            throw new EngineExecutionException("Next state[" + next + "] is not exits", FrameworkErrorCode.ObjectNotExists);
        }
        stateInstruction.setStateName(next);
        if (null != LoopTaskUtils.getLoopConfig(context, nextState)) {
            stateInstruction.setTemporaryState(new LoopStartStateImpl());
        }
        return stateInstruction;
    }

    private Instruction compensateRoute(ProcessContext context, State compensationTriggerState) {
        Stack<StateInstance> stateStackToBeCompensated;
        if (Boolean.TRUE.equals(context.getVariable("_first_compensation_state_started"))) {
            Exception exception = (Exception)context.getVariable("currentException");
            if (exception != null) {
                EngineUtils.endStateMachine(context);
                return null;
            }
            StateInstance stateInstance = (StateInstance)context.getVariable("_current_state_instance_");
            if (stateInstance != null && !ExecutionStatus.SU.equals((Object)stateInstance.getStatus())) {
                EngineUtils.endStateMachine(context);
                return null;
            }
        }
        if (!(stateStackToBeCompensated = CompensationHolder.getCurrent(context, true).getStateStackNeedCompensation()).isEmpty()) {
            StateInstance stateToBeCompensated = stateStackToBeCompensated.pop();
            StateMachine stateMachine = (StateMachine)context.getVariable("_current_statemachine_");
            State state = stateMachine.getState(EngineUtils.getOriginStateName(stateToBeCompensated));
            if (state instanceof AbstractTaskState) {
                AbstractTaskState taskState = (AbstractTaskState)state;
                StateInstruction instruction = context.getInstruction(StateInstruction.class);
                State compensateState = null;
                String compensateStateName = taskState.getCompensateState();
                if (StringUtils.hasLength(compensateStateName)) {
                    compensateState = stateMachine.getState(compensateStateName);
                }
                if (compensateState == null && taskState instanceof SubStateMachine) {
                    compensateState = ((SubStateMachine)((Object)taskState)).getCompensateStateObject();
                    instruction.setTemporaryState(compensateState);
                }
                if (compensateState == null) {
                    EngineUtils.endStateMachine(context);
                    return null;
                }
                instruction.setStateName(compensateState.getName());
                CompensationHolder.getCurrent(context, true).addToBeCompensatedState(compensateState.getName(), stateToBeCompensated);
                ((HierarchicalProcessContext)context).setVariableLocally("_first_compensation_state_started", true);
                if (compensateState instanceof CompensateSubStateMachineState) {
                    ((HierarchicalProcessContext)context).setVariableLocally(compensateState.getName() + "_sub_machine_parent_id_", EngineUtils.generateParentId(stateToBeCompensated));
                }
                return instruction;
            }
        }
        context.removeVariable("_is_compensating_");
        String compensationTriggerStateNext = compensationTriggerState.getNext();
        if (StringUtils.isEmpty(compensationTriggerStateNext)) {
            EngineUtils.endStateMachine(context);
            return null;
        }
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        instruction.setStateName(compensationTriggerStateNext);
        return instruction;
    }
}

