/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.tcc;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.exception.ExceptionUtil;
import org.apache.seata.common.exception.RepeatRegistrationException;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.exception.SkipCallbackWrapperException;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.model.Resource;
import org.apache.seata.integration.tx.api.fence.DefaultCommonFenceHandler;
import org.apache.seata.integration.tx.api.fence.hook.TccHook;
import org.apache.seata.integration.tx.api.fence.hook.TccHookManager;
import org.apache.seata.integration.tx.api.remoting.TwoPhaseResult;
import org.apache.seata.rm.AbstractResourceManager;
import org.apache.seata.rm.tcc.TCCResource;
import org.apache.seata.rm.tcc.api.BusinessActionContext;
import org.apache.seata.rm.tcc.api.BusinessActionContextUtil;

public class TCCResourceManager
extends AbstractResourceManager {
    private Map<String, Resource> tccResourceCache = new ConcurrentHashMap<String, Resource>();

    @Override
    public void registerResource(Resource resource) {
        Object oldResourceBean;
        Object newResourceBean;
        String resourceId = resource.getResourceId();
        TCCResource newResource = (TCCResource)resource;
        TCCResource oldResource = this.getTCCResource(resourceId);
        if (oldResource != null && (newResourceBean = newResource.getTargetBean()) != (oldResourceBean = oldResource.getTargetBean())) {
            throw new RepeatRegistrationException(String.format("Same TCC resource name <%s> between method1 <%s> of class1 <%s> and method2 <%s> of class2 <%s>, should be unique", resourceId, newResource.getPrepareMethod().getName(), newResourceBean.getClass().getName(), oldResource.getPrepareMethod().getName(), oldResourceBean.getClass().getName()));
        }
        this.tccResourceCache.put(resourceId, newResource);
        super.registerResource(newResource);
    }

    public TCCResource getTCCResource(String resourceId) {
        return (TCCResource)this.tccResourceCache.get(resourceId);
    }

    @Override
    public Map<String, Resource> getManagedResources() {
        return this.tccResourceCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BranchStatus branchCommit(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        TCCResource tccResource = this.getTCCResource(resourceId);
        if (tccResource == null) {
            throw new ShouldNeverHappenException(String.format("TCC resource is not exist, resourceId: %s", resourceId));
        }
        Object targetTCCBean = tccResource.getTargetBean();
        Method commitMethod = tccResource.getCommitMethod();
        if (targetTCCBean == null || commitMethod == null) {
            throw new ShouldNeverHappenException(String.format("TCC resource is not available, resourceId: %s", resourceId));
        }
        BusinessActionContext businessActionContext = null;
        try {
            boolean result;
            businessActionContext = BusinessActionContextUtil.getBusinessActionContext(xid, branchId, resourceId, applicationData);
            Object[] args = this.getTwoPhaseCommitArgs(tccResource, businessActionContext);
            BusinessActionContextUtil.setContext(businessActionContext);
            this.doBeforeTccCommit(xid, branchId, tccResource.getActionName(), businessActionContext);
            if (Boolean.TRUE.equals(businessActionContext.getActionContext("useTCCFence"))) {
                try {
                    result = DefaultCommonFenceHandler.get().commitFence(commitMethod, targetTCCBean, xid, branchId, args);
                }
                catch (UndeclaredThrowableException | SkipCallbackWrapperException e) {
                    throw e.getCause();
                }
            } else {
                Object ret = commitMethod.invoke(targetTCCBean, args);
                result = ret != null ? (ret instanceof TwoPhaseResult ? ((TwoPhaseResult)ret).isSuccess() : ((Boolean)ret).booleanValue()) : true;
            }
            LOGGER.info("TCC resource commit result : {}, xid: {}, branchId: {}, resourceId: {}", new Object[]{result, xid, branchId, resourceId});
            BranchStatus branchStatus = result ? BranchStatus.PhaseTwo_Committed : BranchStatus.PhaseTwo_CommitFailed_Retryable;
            return branchStatus;
        }
        catch (Throwable t) {
            String msg = String.format("commit TCC resource error, resourceId: %s, xid: %s.", resourceId, xid);
            LOGGER.error(msg, ExceptionUtil.unwrap(t));
            BranchStatus branchStatus = BranchStatus.PhaseTwo_CommitFailed_Retryable;
            return branchStatus;
        }
        finally {
            this.doAfterTccCommit(xid, branchId, tccResource.getActionName(), businessActionContext);
            BusinessActionContextUtil.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BranchStatus branchRollback(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        TCCResource tccResource = this.getTCCResource(resourceId);
        if (tccResource == null) {
            throw new ShouldNeverHappenException(String.format("TCC resource is not exist, resourceId: %s", resourceId));
        }
        Object targetTCCBean = tccResource.getTargetBean();
        Method rollbackMethod = tccResource.getRollbackMethod();
        if (targetTCCBean == null || rollbackMethod == null) {
            throw new ShouldNeverHappenException(String.format("TCC resource is not available, resourceId: %s", resourceId));
        }
        BusinessActionContext businessActionContext = null;
        try {
            boolean result;
            businessActionContext = BusinessActionContextUtil.getBusinessActionContext(xid, branchId, resourceId, applicationData);
            Object[] args = this.getTwoPhaseRollbackArgs(tccResource, businessActionContext);
            BusinessActionContextUtil.setContext(businessActionContext);
            this.doBeforeTccRollback(xid, branchId, tccResource.getActionName(), businessActionContext);
            if (Boolean.TRUE.equals(businessActionContext.getActionContext("useTCCFence"))) {
                try {
                    result = DefaultCommonFenceHandler.get().rollbackFence(rollbackMethod, targetTCCBean, xid, branchId, args, tccResource.getActionName());
                }
                catch (UndeclaredThrowableException | SkipCallbackWrapperException e) {
                    throw e.getCause();
                }
            } else {
                Object ret = rollbackMethod.invoke(targetTCCBean, args);
                result = ret != null ? (ret instanceof TwoPhaseResult ? ((TwoPhaseResult)ret).isSuccess() : ((Boolean)ret).booleanValue()) : true;
            }
            LOGGER.info("TCC resource rollback result : {}, xid: {}, branchId: {}, resourceId: {}", new Object[]{result, xid, branchId, resourceId});
            BranchStatus branchStatus = result ? BranchStatus.PhaseTwo_Rollbacked : BranchStatus.PhaseTwo_RollbackFailed_Retryable;
            return branchStatus;
        }
        catch (Throwable t) {
            String msg = String.format("rollback TCC resource error, resourceId: %s, xid: %s.", resourceId, xid);
            LOGGER.error(msg, ExceptionUtil.unwrap(t));
            BranchStatus branchStatus = BranchStatus.PhaseTwo_RollbackFailed_Retryable;
            return branchStatus;
        }
        finally {
            this.doAfterTccRollback(xid, branchId, tccResource.getActionName(), businessActionContext);
            BusinessActionContextUtil.clear();
        }
    }

    private void doBeforeTccRollback(String xid, long branchId, String actionName, BusinessActionContext context) {
        List<TccHook> hooks = TccHookManager.getHooks();
        if (hooks.isEmpty()) {
            return;
        }
        for (TccHook hook : hooks) {
            try {
                hook.beforeTccRollback(xid, branchId, actionName, context);
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeTccRollback in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void doAfterTccRollback(String xid, long branchId, String actionName, BusinessActionContext context) {
        List<TccHook> hooks = TccHookManager.getHooks();
        if (hooks.isEmpty()) {
            return;
        }
        for (TccHook hook : hooks) {
            try {
                hook.afterTccRollback(xid, branchId, actionName, context);
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterTccRollback in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void doBeforeTccCommit(String xid, long branchId, String actionName, BusinessActionContext context) {
        List<TccHook> hooks = TccHookManager.getHooks();
        if (hooks.isEmpty()) {
            return;
        }
        for (TccHook hook : hooks) {
            try {
                hook.beforeTccCommit(xid, branchId, actionName, context);
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeTccCommit in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void doAfterTccCommit(String xid, long branchId, String actionName, BusinessActionContext context) {
        List<TccHook> hooks = TccHookManager.getHooks();
        if (hooks.isEmpty()) {
            return;
        }
        for (TccHook hook : hooks) {
            try {
                hook.afterTccCommit(xid, branchId, actionName, context);
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterTccCommit in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected Object[] getTwoPhaseCommitArgs(TCCResource tccResource, BusinessActionContext businessActionContext) {
        String[] keys = tccResource.getPhaseTwoCommitKeys();
        Class<?>[] argsCommitClasses = tccResource.getCommitArgsClasses();
        return this.getTwoPhaseMethodParams(keys, argsCommitClasses, businessActionContext);
    }

    private Object[] getTwoPhaseRollbackArgs(TCCResource tccResource, BusinessActionContext businessActionContext) {
        String[] keys = tccResource.getPhaseTwoRollbackKeys();
        Class<?>[] argsRollbackClasses = tccResource.getRollbackArgsClasses();
        return this.getTwoPhaseMethodParams(keys, argsRollbackClasses, businessActionContext);
    }

    protected Object[] getTwoPhaseMethodParams(String[] keys, Class<?>[] argsClasses, BusinessActionContext businessActionContext) {
        Object[] args = new Object[argsClasses.length];
        for (int i = 0; i < argsClasses.length; ++i) {
            args[i] = argsClasses[i].equals(BusinessActionContext.class) ? businessActionContext : businessActionContext.getActionContext(keys[i], argsClasses[i]);
        }
        return args;
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.TCC;
    }
}

