/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.interceptor.parser;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.config.CachedConfigurationChangeListener;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.integration.tx.api.interceptor.handler.GlobalTransactionalInterceptorHandler;
import org.apache.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;
import org.apache.seata.integration.tx.api.interceptor.parser.DefaultTargetClassParser;
import org.apache.seata.integration.tx.api.interceptor.parser.IfNeedEnhanceBean;
import org.apache.seata.integration.tx.api.interceptor.parser.InterfaceParser;
import org.apache.seata.integration.tx.api.interceptor.parser.NeedEnhanceEnum;
import org.apache.seata.spring.annotation.GlobalLock;
import org.apache.seata.spring.annotation.GlobalTransactional;
import org.apache.seata.tm.api.FailureHandlerHolder;

public class GlobalTransactionalInterceptorParser
implements InterfaceParser {
    protected final Set<String> methodsToProxy = new HashSet<String>();

    @Override
    public ProxyInvocationHandler parserInterfaceToProxy(Object target, String objectName) throws Exception {
        Class<?> serviceInterface = DefaultTargetClassParser.get().findTargetClass(target);
        Class<?>[] interfacesIfJdk = DefaultTargetClassParser.get().findInterfaces(target);
        if (this.existsAnnotation(serviceInterface) || this.existsAnnotation(interfacesIfJdk)) {
            ProxyInvocationHandler proxyInvocationHandler = this.createProxyInvocationHandler();
            ConfigurationFactory.getInstance().addConfigListener("service.disableGlobalTransaction", (CachedConfigurationChangeListener)((Object)proxyInvocationHandler));
            return proxyInvocationHandler;
        }
        return null;
    }

    protected ProxyInvocationHandler createProxyInvocationHandler() {
        return new GlobalTransactionalInterceptorHandler(FailureHandlerHolder.getFailureHandler(), this.methodsToProxy);
    }

    @Override
    public IfNeedEnhanceBean parseIfNeedEnhancement(Class<?> beanClass) {
        Set<Class<?>> interfaceClasses = ReflectionUtil.getInterfaces(beanClass);
        Class[] interfaceClasseArray = interfaceClasses.toArray(new Class[0]);
        IfNeedEnhanceBean ifNeedEnhanceBean = new IfNeedEnhanceBean();
        if (this.existsAnnotation(beanClass) || this.existsAnnotation(interfaceClasseArray)) {
            ifNeedEnhanceBean.setIfNeed(true);
            ifNeedEnhanceBean.setNeedEnhanceEnum(NeedEnhanceEnum.GLOBAL_TRANSACTIONAL_BEAN);
        }
        return ifNeedEnhanceBean;
    }

    protected boolean existsAnnotation(Class<?> ... classes) {
        boolean result = false;
        if (CollectionUtils.isNotEmpty(classes)) {
            for (Class<?> clazz : classes) {
                Method[] methods;
                if (clazz == null) continue;
                GlobalTransactional trxAnno = clazz.getAnnotation(GlobalTransactional.class);
                if (trxAnno != null) {
                    return true;
                }
                for (Method method : methods = clazz.getMethods()) {
                    GlobalLock lockAnno;
                    trxAnno = method.getAnnotation(GlobalTransactional.class);
                    if (trxAnno != null) {
                        this.methodsToProxy.add(method.getName());
                        result = true;
                    }
                    if ((lockAnno = method.getAnnotation(GlobalLock.class)) == null) continue;
                    this.methodsToProxy.add(method.getName());
                    result = true;
                }
            }
        }
        return result;
    }
}

